﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Extensions
{
    /// <summary>
    /// Class containing extensions methods related to streams.
    /// </summary>
    public static class StreamExtensions
    {
        /// <summary>
        /// Extract stream content to a byte array.
        /// </summary>
        /// <param name="stream">The stream to extract content.</param>
        /// <returns>Returns a byte array with the content of the stream.</returns>
        public static byte[] ToProperlySizedBuffer(this Stream stream)
        {
            byte[] data = data = new byte[stream.Length];

            stream.Position = 0;
            stream.Read(data, 0, data.Length);

            return data;
        }

        /// <summary>
        /// Extract the content of the stream as a string.
        /// </summary>
        /// <param name="stream">The stream to extract content.</param>
        /// <returns>Returns the content of the stream as a string,
        /// using default encoding. (UTF8)</returns>
        public static string ToProperlySizedString(this Stream stream)
        {
            return stream.ToProperlySizedString(null);
        }

        /// <summary>
        /// Extract the content of the stream as a string.
        /// </summary>
        /// <param name="stream">The stream to extract content.</param>
        /// <param name="encoding">Encoding to transform raw data to string.</param>
        /// <returns>Returns the content of the stream as a string.</returns>
        public static string ToProperlySizedString(this Stream stream, Encoding encoding)
        {
            byte[] data = stream.ToProperlySizedBuffer();

            if (encoding == null)
            {
                encoding = Encoding.UTF8;
            }

            return encoding.GetString(data);
        }
    }
}
