﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/背景画像タブデータです。
    /// </summary>
    [Serializable]
    public class ViewerBackgroundData : DataModelBase
    {
        /// <summary>
        /// 背景カラーです。
        /// </summary>
        private ViewerBackgroundColorData backgroundColorData = null;

        /// <summary>
        /// 背景画像です。
        /// </summary>
        private ViewerBackgroundImageData backgroundImageData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBackgroundData() :
            base()
        {
        }

        /// <summary>
        /// 背景カラーです。
        /// </summary>
        [DataModelPropertyGuid("a4dccfcd-727e-444d-b3a1-cf7811fc60c8")]
        public ViewerBackgroundColorData BackgroundColorData
        {
            get { return this.GetDataModelFromField(ref this.backgroundColorData, false); }
            set { this.SetDataModelToField(ref this.backgroundColorData, value); }
        }

        /// <summary>
        /// 背景画像です。
        /// </summary>
        [DataModelPropertyGuid("41fa7cab-2fde-4ec5-b27e-eb14f3b60f13")]
        public ViewerBackgroundImageData BackgroundImageData
        {
            get { return this.GetDataModelFromField(ref this.backgroundImageData, false); }
            set { this.SetDataModelToField(ref this.backgroundImageData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ViewerBackgroundData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.BackgroundColorData = srcDataModel.BackgroundColorData;
            this.BackgroundImageData = srcDataModel.BackgroundImageData;

            return true;
        }
    }
}
