﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    ///
    /// </summary>
    [Serializable]
    public class StripeHistoryData : StripeData
    {
        /// <summary>
        /// ストライプのユーザページのデータです。

        /// </summary>
        private UserDataBase userPageData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public StripeHistoryData() :
            base()
        {
        }

        /// <summary>
        /// ストライプのユーザページのデータです。
        ///
        /// </summary>
        [DataModelPropertyGuid("b4d49969-cb01-4e14-9522-5555274552ec")]
        public UserDataBase UserPageData
        {
            get { return this.GetDataModelFromField(ref this.userPageData, true); }
            set { this.SetDataModelToField(ref this.userPageData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as StripeHistoryData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.UserPageData = srcDataModel.UserPageData;

            return true;
        }
    }
}
