﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.ObjectModel;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// オフセット行列データ.
    /// </summary>
    [Serializable]
    public class PreviewMatrixOffsetMatrixData : DataModelBase
    {
        /// <summary>
        ///
        /// </summary>
        private Vector3f offsetScale = null;

        /// <summary>
        /// 座標.
        /// </summary>
        private Vector3f offsetPosition = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewMatrixOffsetMatrixData() :
            base()
        {
            this.OffsetScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterBillboard = false;
            this.OffsetRotationX = 0.0f;
            this.OffsetRotationY = 0.0f;
            this.OffsetRotationZ = 0.0f;
            this.OffsetPosition = new Vector3f(0.0f, 0.0f, 0.0f);
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("7d04f4d3-fbe9-464b-9006-94cbe27f3db4")]
        public Vector3f OffsetScale
        {
            get { return this.GetObjectFromField(ref this.offsetScale, false); }
            set { this.SetISettableToField(ref this.offsetScale, value); }
        }

        /// <summary>
        /// エミッタビルボード.
        /// </summary>
        [DataModelPropertyGuid("07a067fd-51f5-4381-832e-df32a173ee71")]
        public bool EmitterBillboard { get; set; }

        /// <summary>
        /// 回転X.
        /// </summary>
        [DataModelPropertyGuid("d63c2ca6-67e8-40cc-b147-37826c659713")]
        public float OffsetRotationX { get; set; }

        /// <summary>
        /// 回転Y.
        /// </summary>
        [DataModelPropertyGuid("0bde001c-f6e3-4e61-b90d-f812b6780e60")]
        public float OffsetRotationY { get; set; }

        /// <summary>
        /// 回転Z
        /// </summary>
        [DataModelPropertyGuid("64ab611e-9094-4b8f-af7a-fece381e4b1e")]
        public float OffsetRotationZ { get; set; }

        /// <summary>
        /// 座標.
        /// </summary>
        [DataModelPropertyGuid("59d7cccb-beaf-4ae2-a0a3-5699d0332d5f")]
        public Vector3f OffsetPosition
        {
            get { return this.GetObjectFromField(ref this.offsetPosition, false); }
            set { this.SetISettableToField(ref this.offsetPosition, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PreviewMatrixOffsetMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.OffsetScale = srcDataModel.OffsetScale;
            this.EmitterBillboard = srcDataModel.EmitterBillboard;
            this.OffsetRotationX = srcDataModel.OffsetRotationX;
            this.OffsetRotationY = srcDataModel.OffsetRotationY;
            this.OffsetRotationZ = srcDataModel.OffsetRotationZ;
            this.OffsetPosition = srcDataModel.OffsetPosition;

            return true;
        }
    }
}
