﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Collections.ObjectModel;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデル連携.
    /// </summary>
    [Serializable]
    public class PreviewMatrixModelRelationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewMatrixModelRelationData() :
            base()
        {
            this.MatrixApplyMode = 0;
            this.PreviewModelIndex = -1;
            this.ModelGuid = System.Guid.Empty;
            this.ModelName = string.Empty;
            this.BoneIndex = 0;
            this.BoneName = string.Empty;
        }

        /// <summary>
        /// マトリクス適用モード.
        /// </summary>
        [DataModelPropertyGuid("eb57397e-86e4-42e0-8442-3e79fef2c3d1")]
        public int MatrixApplyMode { get; set; }

        /// <summary>
        /// 接続モデル.
        /// </summary>
        [DataModelPropertyGuid("05285da9-69b0-42a4-9da7-44431189c81a")]
        public int PreviewModelIndex { get; set; }

        /// <summary>
        /// モデルのGUID.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a0ef7bf4-bad5-4f26-a8fa-a3e970f91a92")]
        public Guid ModelGuid { get; set; }

        /// <summary>
        /// モデル名.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("b9c7f5bf-87ce-4e60-bab5-c87de12e135e")]
        public string ModelName { get; set; }

        /// <summary>
        /// 接続ボーン.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("6008d239-972d-4981-9fe7-a311f5356a7d")]
        public int BoneIndex { get; set; }

        /// <summary>
        /// ボーン名.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3010e5f8-2890-432c-9707-89bb684b863d")]
        public string BoneName { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as PreviewMatrixModelRelationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MatrixApplyMode = srcDataModel.MatrixApplyMode;
            this.PreviewModelIndex = srcDataModel.PreviewModelIndex;
            this.ModelGuid = srcDataModel.ModelGuid;
            this.ModelName = srcDataModel.ModelName;
            this.BoneIndex = srcDataModel.BoneIndex;
            this.BoneName = srcDataModel.BoneName;

            return true;
        }
    }
}
