﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Viewerにモデルバイナリを送るための暫定データです。
    /// </summary>
    [Serializable]
    public class ModelConstrainData : DataModelBase
    {
        /// <summary>
        ///
        /// </summary>
        private Vector3f offsetPosition = null;

        /// <summary>
        ///
        /// </summary>
        private Vector3f offsetScale = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelConstrainData() :
            base()
        {
            this.ModelGuid = System.Guid.Empty;

        //    this.PostConstruct();
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("423f6f6e-425e-4963-8886-331b220b896d")]
        public int MatrixSetType { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("d52f44a7-434e-4008-85b2-b2c70e6fd9dd")]
        public int MatrixApplyType { get; set; }

        /// <summary>
        /// モデルのＧＵＩＤです。
        /// </summary>
        [DataModelPropertyGuid("dab69fc1-8b9f-4902-9320-ca0cc2442948")]
        public Guid ModelGuid { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("9937ec1c-c7d4-4736-bdef-0d7bed82bf34")]
        public int ModelIndex { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("ad6eb146-78f9-4599-98bf-d8e3d5782b48")]
        public int BoneIndex { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("8c20b965-52ea-4a71-a1f4-c472b268779e")]
        public Vector3f OffsetPosition
        {
            get { return this.GetObjectFromField(ref this.offsetPosition, false); }
            set { this.SetISettableToField(ref this.offsetPosition, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("00553d61-1a52-49ee-8881-2816995ab43b")]
        public Vector3f OffsetScale
        {
            get { return this.GetObjectFromField(ref this.offsetScale, false); }
            set { this.SetISettableToField(ref this.offsetScale, value); }
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("c96aa87f-9024-4536-8d5d-b9b3a8132393")]
        public float OffsetRotateX { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("a272ee8a-cac4-47dd-a913-fa2c37eb04a9")]
        public float OffsetRotateY { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("be819480-a1ac-4384-b3d6-af5dc6b4d404")]
        public float OffsetRotateZ { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("81980d50-6217-4ce4-afdd-889fc39ae35b")]
        public bool IsEmitterBillboard { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ModelConstrainData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MatrixSetType = srcDataModel.MatrixSetType;
            this.MatrixApplyType = srcDataModel.MatrixApplyType;
            this.ModelGuid = srcDataModel.ModelGuid;
            this.ModelIndex = srcDataModel.ModelIndex;
            this.BoneIndex = srcDataModel.BoneIndex;
            this.OffsetPosition = srcDataModel.OffsetPosition;
            this.OffsetScale = srcDataModel.OffsetScale;
            this.OffsetRotateX = srcDataModel.OffsetRotateX;
            this.OffsetRotateY = srcDataModel.OffsetRotateY;
            this.OffsetRotateZ = srcDataModel.OffsetRotateZ;
            this.IsEmitterBillboard = srcDataModel.IsEmitterBillboard;

            return true;
        }
    }
}
