﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブ/再生設定グループデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicPlaybackData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicPlaybackData() :
            base()
        {
            this.AnimationSpeed = 1.0f;
            this.AnimationStartFrame = 0;
        }

        /// <summary>
        /// 再生速度です.
        /// </summary>
        [DataModelPropertyGuid("b42bc854-29a7-45a6-ae35-828062ee0f8d")]
        public float AnimationSpeed { get; set; }

        /// <summary>
        /// 再生開始フレームです.
        /// </summary>
        [DataModelPropertyGuid("ef360af6-649e-4178-9d23-d69059128d1b")]
        public float AnimationStartFrame { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ModelBasicPlaybackData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationSpeed = srcDataModel.AnimationSpeed;
            this.AnimationStartFrame = srcDataModel.AnimationStartFrame;

            return true;
        }
    }
}
