﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/位置に加算データです。
    /// </summary>
    [Serializable]
    public class AddLocationParamData : DataModelBase
    {
        /// <summary>
        /// 加算値.
        /// </summary>
        private Vector3f addition = null;

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public AddLocationParamData() :
            base()
        {
            this.AddGlobal = false;
            this.Addition = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EnableAnimation = 0;
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;
        }

        /// <summary>
        /// ワールド座標系で適用するかどうかのフラグです。
        /// </summary>
        [DataModelPropertyGuid("7d76d9a8-4678-45db-9ff2-93ef369d0d8d")]
        public bool AddGlobal { get; set; }

        /// <summary>
        /// 加算値.
        /// </summary>
        [DataModelPropertyGuid("ffcb33b5-660b-4e6d-b74c-d03801097de3")]
        public Vector3f Addition
        {
            get { return this.GetObjectFromField(ref this.addition, false); }
            set { this.SetISettableToField(ref this.addition, value); }
        }

        /// <summary>
        /// アニメーションの有無を表すフラグです。
        /// </summary>
        [DataModelPropertyGuid("036d10aa-8d95-416b-8a48-492990e7e6de")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// アニメーションテーブルです。
        /// </summary>
        [DataModelPropertyGuid("7b091aff-4c7f-4820-9a27-b31f5274875e")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// アニメーションの再生タイプです。
        /// </summary>
        [DataModelPropertyGuid("6cc3a5b5-c68f-4771-95fa-39e69438e128")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生にした際の終端フレームです。
        ///
        /// </summary>
        [DataModelPropertyGuid("8e8b9076-d30b-4e4d-a410-dba9d884b928")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置をランダム化するか否かのフラグです。
        /// </summary>
        [DataModelPropertyGuid("e8cebe60-47a0-4ff2-afe8-0f4a20125f9a")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as AddLocationParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AddGlobal = srcDataModel.AddGlobal;
            this.Addition = srcDataModel.Addition;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
