﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Xml;
using System.Xml.Schema;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャパターンアニメーショングループデータです。
    /// </summary>
    [Serializable]
    public class EmitterTexturePatternAnimationData : DataModelBase, IXmlSerializable
    {
        /// <summary>
        /// パターンテーブルです.
        /// </summary>
        private ArrayCollection<int> patternTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTexturePatternAnimationData() :
            base()
        {
            this.PatternAnimType = 0;
            this.DurationCountPerFrame = 1;
            this.PatternTableCount = 2;
            this.RandomPatternTableCount = 1;
            this.EnableSimpleTableRandom = false;
            this.SimpleTableInput = string.Empty;
        }

        /// <summary>
        /// 再生方法.
        /// </summary>
        [DataModelPropertyGuid("dabd4b10-4cd5-4a0b-bc00-ee99e2aa5ff1")]
        public int PatternAnimType { get; set; }

        /// <summary>
        /// 1コマの継続フレーム数です。
        /// </summary>
        [DataModelPropertyGuid("795849ff-cffc-4a89-8be0-bdc45a02dbc0")]
        public int DurationCountPerFrame { get; set; }

        /// <summary>
        /// 使用パターンテーブル数です。
        /// </summary>
        [DataModelPropertyGuid("a01a612a-d8e9-4adf-a82a-04d2c33a4e50")]
        public int PatternTableCount { get; set; }

        /// <summary>
        /// ランダム設定時の使用パターンテーブル数です。
        /// </summary>
        [DataModelPropertyGuid("18503eae-62fc-4a60-aa1e-4d81f561ea17")]
        public int RandomPatternTableCount { get; set; }

        /// <summary>
        /// 簡易テーブルランダムの有効化フラグです。
        /// </summary>
        [DataModelPropertyGuid("447492e2-2562-421b-8e4a-f38e05c90476")]
        public bool EnableSimpleTableRandom { get; set; }

        /// <summary>
        /// テーブル簡易入力です.
        /// </summary>
        [DataModelPropertyGuid("2f2c4f16-19ee-4438-8df8-34bb5fd72591")]
        public string SimpleTableInput { get; set; }

        /// <summary>
        /// パターンテーブルです.
        /// </summary>
        [DataModelPropertyGuid("36352cd0-4606-4234-81ec-258f0adb9ab8")]
        public ArrayCollection<int> PatternTable
        {
            get
            {
                if (this.patternTable == null)
                {
                    this.patternTable = new ArrayCollection<int>(32);
                }

                return this.patternTable.Clone() as ArrayCollection<int>;
            }

            set
            {
                if (this.patternTable == null)
                {
                    this.patternTable = new ArrayCollection<int>(32);
                }

                this.patternTable.Set(value);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterTexturePatternAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.PatternAnimType = srcDataModel.PatternAnimType;
            this.DurationCountPerFrame = srcDataModel.DurationCountPerFrame;
            this.PatternTableCount = srcDataModel.PatternTableCount;
            this.RandomPatternTableCount = srcDataModel.RandomPatternTableCount;
            this.EnableSimpleTableRandom = srcDataModel.EnableSimpleTableRandom;
            this.SimpleTableInput = srcDataModel.SimpleTableInput;
            this.PatternTable = srcDataModel.PatternTable;

            return true;
        }

        public XmlSchema GetSchema()
        {
            // NO RETURN
            return null;
        }

        public void ReadXml(XmlReader reader)
        {
            // DO NOTHING
        }

        public void WriteXml(XmlWriter writer)
        {
            ////writer.WriteElementString("Guid", this.Guid.ToString());
            writer.WriteElementString("PatternAnimType", this.PatternAnimType.ToString("D"));
            writer.WriteElementString("DurationCountPerFrame", this.DurationCountPerFrame.ToString("D"));
            writer.WriteElementString("PatternTableCount", this.PatternTableCount.ToString("D"));
            writer.WriteElementString("RandomPatternTableCount", this.RandomPatternTableCount.ToString("D"));
            writer.WriteElementString("EnableSimpleTableRandom", this.EnableSimpleTableRandom.ToString());
            writer.WriteElementString("SimpleTableInput", this.SimpleTableInput);
            writer.WriteStartElement("PatternTable");
            writer.WriteAttributeString("Count", "32");
            for (int i = 0; i < 32; ++i)
            {
                writer.WriteElementString("Int32", this.PatternTable[i].ToString("D"));
            }

            writer.WriteEndElement();
        }
    }
}
