﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The data model that contains texture data models in the emitter.
    /// </summary>
    [Serializable]
    public class EmitterTextureGroupData : DataModelBase
    {
        /// <summary>
        /// Get or set the data model for emitter texture 0.
        /// </summary>
        private EmitterTextureData texture0 = null;

        /// <summary>
        /// Get or set the data model for emitter texture 1.
        /// </summary>
        private EmitterTextureData texture1 = null;

        /// <summary>
        /// Get or set the data model for emitter texture 2.
        /// </summary>
        private EmitterTextureData texture2 = null;

        /// <summary>
        /// 共通設定サブタブです.
        /// </summary>
        private EmitterTextureCommonSettingsData commonSettings = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureGroupData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the data model for emitter texture 0.
        /// </summary>
        [DataModelPropertyGuid("48a87496-8290-44ca-9497-235cf63b2443")]
        public EmitterTextureData Texture0
        {
            get { return this.GetDataModelFromField(ref this.texture0, false); }
            set { this.SetDataModelToField(ref this.texture0, value); }
        }

        /// <summary>
        /// Get or set the data model for emitter texture 1.
        /// </summary>
        [DataModelPropertyGuid("34ea0d57-c02f-454d-b9e0-5b42bb3bc0ac")]
        public EmitterTextureData Texture1
        {
            get { return this.GetDataModelFromField(ref this.texture1, false); }
            set { this.SetDataModelToField(ref this.texture1, value); }
        }

        /// <summary>
        /// Get or set the data model for emitter texture 2.
        /// </summary>
        [DataModelPropertyGuid("050c90de-884a-4741-bc8c-1e2a6a479334")]
        public EmitterTextureData Texture2
        {
            get { return this.GetDataModelFromField(ref this.texture2, false); }
            set { this.SetDataModelToField(ref this.texture2, value); }
        }

        /// <summary>
        /// 共通設定サブタブです.
        /// </summary>
        [DataModelPropertyGuid("2188a8e3-0985-4250-af8f-d50b867a924a")]
        public EmitterTextureCommonSettingsData CommonSettings
        {
            get { return this.GetDataModelFromField(ref this.commonSettings, false); }
            set { this.SetDataModelToField(ref this.commonSettings, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterTextureGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Texture0 = srcDataModel.Texture0;
            this.Texture1 = srcDataModel.Texture1;
            this.Texture2 = srcDataModel.Texture2;
            this.CommonSettings = srcDataModel.CommonSettings;

            return true;
        }
    }
}
