﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/回転タブ/回転軸Xグループです。
    /// </summary>
    [Serializable]
    public class EmitterRotationXData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationXData() :
            base()
        {
            this.InitialRotation = 0.0f;
            this.InitialRotationRandom = 0.0f;
            this.EnableRotationRandom = false;
            this.RotationSpeed = 0.0f;
            this.RotationSpeedRandom = 0.0f;
        }

        /// <summary>
        /// 初期回転(X軸)です.
        /// </summary>
        [DataModelPropertyGuid("9652748f-cd87-409c-a2c5-5b8f265f8a8c")]
        public float InitialRotation { get; set; }

        /// <summary>
        /// 回転のランダム幅(X軸)です.
        /// </summary>
        [DataModelPropertyGuid("aab40f58-4618-4fc0-8703-a306ac0c0c02")]
        public float InitialRotationRandom { get; set; }

        /// <summary>
        /// 回転方向ランダム(X軸)です.
        /// </summary>
        [DataModelPropertyGuid("94acadb3-e7fd-4a4f-8e27-ce3a1d6e9945")]
        public bool EnableRotationRandom { get; set; }

        /// <summary>
        /// 回転速度(X軸)です.
        /// </summary>
        [DataModelPropertyGuid("a825d6e8-4462-49e5-a97c-34b4d40f629a")]
        public float RotationSpeed { get; set; }

        /// <summary>
        /// 回転速度のランダム幅(X軸)です.
        /// </summary>
        [DataModelPropertyGuid("2b566c9e-f297-416c-bba7-8c9da04fa9ca")]
        public float RotationSpeedRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterRotationXData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.InitialRotation = srcDataModel.InitialRotation;
            this.InitialRotationRandom = srcDataModel.InitialRotationRandom;
            this.EnableRotationRandom = srcDataModel.EnableRotationRandom;
            this.RotationSpeed = srcDataModel.RotationSpeed;
            this.RotationSpeedRandom = srcDataModel.RotationSpeedRandom;

            return true;
        }
    }
}
