﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Primitives;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 回転タブデータです.
    /// </summary>
    [Serializable]
    public class EmitterRotationData : DataModelBase
    {
        /// <summary>
        /// 基本設定グループです.
        /// </summary>
        private EmitterRotationBasicData emitterRotationBasicData = null;

        /// <summary>
        /// 回転軸Xグループです.
        /// </summary>
        private EmitterRotationXData emitterRotationXData = null;

        /// <summary>
        /// 回転軸Yグループです.
        /// </summary>
        private EmitterRotationYData emitterRotationYData = null;

        /// <summary>
        /// 回転軸Zグループです.
        /// </summary>
        private EmitterRotationZData emitterRotationZData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterRotationData() :
            base()
        {
        }

        /// <summary>
        /// 基本設定グループです.
        /// </summary>
        [DataModelPropertyGuid("d7092259-2937-44ce-be23-638912b8d67b")]
        public EmitterRotationBasicData EmitterRotationBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationBasicData, value); }
        }

        /// <summary>
        /// 回転軸Xグループです.
        /// </summary>
        [DataModelPropertyGuid("dc0bd411-2f87-4994-a2c8-37a2d09e683f")]
        public EmitterRotationXData EmitterRotationXData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationXData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationXData, value); }
        }

        /// <summary>
        /// 回転軸Yグループです.
        /// </summary>
        [DataModelPropertyGuid("5c2901c6-6f5d-498c-80b0-7085faec7fb6")]
        public EmitterRotationYData EmitterRotationYData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationYData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationYData, value); }
        }

        /// <summary>
        /// 回転軸Zグループです.
        /// </summary>
        [DataModelPropertyGuid("36e6d347-d7ab-4e60-a235-032fec9c24f1")]
        public EmitterRotationZData EmitterRotationZData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationZData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationZData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterRotationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterRotationBasicData = srcDataModel.EmitterRotationBasicData;
            this.EmitterRotationXData = srcDataModel.EmitterRotationXData;
            this.EmitterRotationYData = srcDataModel.EmitterRotationYData;
            this.EmitterRotationZData = srcDataModel.EmitterRotationZData;

            return true;
        }
    }
}
