﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Primitives;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタデータです.
    /// </summary>
    [Serializable]
    public class EmitterData : DataModelBase
    {
        /// <summary>
        /// 基本設定データです.
        /// </summary>
        private EmitterBasicSettingData emitterBasicSettingData = null;

        /// <summary>
        /// 放出データです.
        /// </summary>
        private EmitterEmissionData emitterEmissionData = null;

        /// <summary>
        /// エミッタデータです.
        /// </summary>
        private EmitterEmitterData emitterEmitterData = null;

        /// <summary>
        /// パーティクルデータです.
        /// </summary>
        private EmitterParticleData emitterParticleData = null;

        /// <summary>
        /// コンバイナデータです.
        /// </summary>
        private EmitterCombinerData emitterCombinerData = null;

        /// <summary>
        /// Get or set the emitter texture group data.
        /// </summary>
        private EmitterTextureGroupData textures = null;

        /// <summary>
        /// カラーデータです.
        /// </summary>
        private EmitterColorGroupData emitterColorData = null;

        /// <summary>
        /// スケールデータです.
        /// </summary>
        private EmitterScaleData emitterScaleData = null;

        /// <summary>
        /// 回転データです.
        /// </summary>
        private EmitterRotationData emitterRotationData = null;

        /// <summary>
        /// エミッタリストです
        /// </summary>
        private List<EmitterData> emitterList = null;

        /// <summary>
        /// フィールドリストです.
        /// </summary>
        private List<FieldDataBase> fieldList = null;

        /// <summary>
        /// ユーザーデータリストです.
        /// </summary>
        private List<UserDataBase> userDataList = null;

        /// <summary>
        /// ストライプデータです.
        /// </summary>
        private StripeData stripeData = null;

        /// <summary>
        /// カスタムシェーダーです
        /// </summary>
        private EmitterCustomShaderData emitterCustomShaderData = null;

        /// <summary>
        /// カスタムアクションです。
        /// </summary>
        private CustomActionData customActionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterData() :
            base()
        {
            this.Name = string.Empty;
        }

        /// <summary>
        /// エミッタ名です.
        /// </summary>
        [DataModelPropertyGuid("2d4eb3ba-cee7-4748-8696-fe3bafe9c92a")]
        public string Name { get; set; }

        /// <summary>
        /// Enumerate the file path of the textures the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e8a631f6-4dbe-4caa-84a3-895bca13de8c")]
        public IEnumerable<string> TexturePaths
        {
            get
            {
                string path = this.Textures.Texture0.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }

                path = this.Textures.Texture1.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }

                path = this.Textures.Texture2.EmitterTextureFileData.FilePath;
                if (string.IsNullOrEmpty(path) == false)
                {
                    yield return path;
                }
            }
        }

        /// <summary>
        /// Enumerate the file path of the primitive the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3ba29d76-de31-4a4c-8ccd-6e96c045391b")]
        public IEnumerable<string> PrimitivePaths
        {
            get
            {
                string path = this.EmitterParticleData.EmitterParticleShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterParticleData.EmitterParticleShapeData.ShapeType != 0)
                {
                    yield return path;
                }

                path = this.EmitterEmitterData.EmitterEmitterShapeData.PrimitiveFilePath;
                if (string.IsNullOrEmpty(path) == false && this.EmitterEmitterData.EmitterEmitterShapeData.EmitterType == 15)
                {
                    yield return path;
                }
            }
        }

        /// <summary>
        /// Get the index of the custom shader the emitter uses.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("c14a98d9-afad-4650-8b5a-d75ef1a03a95")]
        public int CustomShaderIndex
        {
            get
            {
                return this.EmitterCustomShaderData.SelectedSettingIndex;
            }
        }

        /// <summary>
        /// 基本設定データです.
        /// </summary>
        [DataModelPropertyGuid("9cea8a5b-1e28-4d86-8cdd-ad7ee5cf6988")]
        public EmitterBasicSettingData EmitterBasicSettingData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicSettingData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicSettingData, value); }
        }

        /// <summary>
        /// 放出データです.
        /// </summary>
        [DataModelPropertyGuid("4a5e8356-d75d-4364-9eb6-e0b1cb7de6af")]
        public EmitterEmissionData EmitterEmissionData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmissionData, false); }
            set { this.SetDataModelToField(ref this.emitterEmissionData, value); }
        }

        /// <summary>
        /// エミッタデータです.
        /// </summary>
        [DataModelPropertyGuid("23df82b8-3b85-4848-ba0c-a9d72d86bc71")]
        public EmitterEmitterData EmitterEmitterData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterData, value); }
        }

        /// <summary>
        /// パーティクルデータです.
        /// </summary>
        [DataModelPropertyGuid("6ac7e463-f934-46e2-83e4-3afb64fe6fe8")]
        public EmitterParticleData EmitterParticleData
        {
            get { return this.GetDataModelFromField(ref this.emitterParticleData, false); }
            set { this.SetDataModelToField(ref this.emitterParticleData, value); }
        }

        /// <summary>
        /// コンバイナデータです.
        /// </summary>
        [DataModelPropertyGuid("8f364c8d-21da-4ddf-a7c8-c81a5b8d7980")]
        public EmitterCombinerData EmitterCombinerData
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerData, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerData, value); }
        }

        /// <summary>
        /// Get or set the emitter texture group data.
        /// </summary>
        [DataModelPropertyGuid("0fc151b6-644a-4c23-8a6e-fd6ea1bed196")]
        public EmitterTextureGroupData Textures
        {
            get { return this.GetDataModelFromField(ref this.textures, false); }
            set { this.SetDataModelToField(ref this.textures, value); }
        }

        /// <summary>
        /// カラーデータです.
        /// </summary>
        [DataModelPropertyGuid("98ebb26e-d6c8-43c6-85d4-2392b9e528e6")]
        public EmitterColorGroupData EmitterColorData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorData, false); }
            set { this.SetDataModelToField(ref this.emitterColorData, value); }
        }

        /// <summary>
        /// スケールデータです.
        /// </summary>
        [DataModelPropertyGuid("37cb7fc7-b116-471d-962f-356775e4a42f")]
        public EmitterScaleData EmitterScaleData
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleData, false); }
            set { this.SetDataModelToField(ref this.emitterScaleData, value); }
        }

        /// <summary>
        /// 回転データです.
        /// </summary>
        [DataModelPropertyGuid("4b2d534d-9371-433b-a4bc-e202efd90b75")]
        public EmitterRotationData EmitterRotationData
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationData, false); }
            set { this.SetDataModelToField(ref this.emitterRotationData, value); }
        }

        /// <summary>
        /// Get all the emitters by performing a recursive search through all the child emitters.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a97ef49d-27dd-4f24-898e-ce1f06d07571")]
        public IEnumerable<EmitterData> AllChildEmitters
        {
            get
            {
                foreach (EmitterData item in this.EmitterList)
                {
                    yield return item;

                    foreach (EmitterData child in item.AllChildEmitters)
                    {
                        yield return child;
                    }
                }
            }
        }

        /// <summary>
        /// エミッタリストです
        /// </summary>
        [DataModelPropertyGuid("692d03e8-4727-435b-944f-73c8ca273cdb")]
        public List<EmitterData> EmitterList
        {
            get { return this.GetDataModelListFromField(ref this.emitterList); }
            set { this.SetDataModelListToField(ref this.emitterList, value); }
        }

        /// <summary>
        /// フィールドリストです.
        /// </summary>
        [DataModelPropertyGuid("1f8c72df-e171-4bb4-99fa-038fe632c6ee")]
        public List<FieldDataBase> FieldList
        {
            get { return this.GetDataModelListFromField(ref this.fieldList); }
            set { this.SetDataModelListToField(ref this.fieldList, value); }
        }

        /// <summary>
        /// ユーザーデータリストです.
        /// </summary>
        [DataModelPropertyGuid("dfb11720-db97-4b98-8ae1-3f30196575c0")]
        public List<UserDataBase> UserDataList
        {
            get { return this.GetDataModelListFromField(ref this.userDataList); }
            set { this.SetDataModelListToField(ref this.userDataList, value); }
        }

        /// <summary>
        /// ストライプデータです.
        /// </summary>
        [DataModelPropertyGuid("32bbeca7-a2ce-42af-ab2d-09d485a230e3")]
        public StripeData StripeData
        {
            get { return this.GetDataModelFromField(ref this.stripeData, true); }
            set { this.SetDataModelToField(ref this.stripeData, value); }
        }

        /// <summary>
        /// カスタムシェーダーです
        /// </summary>
        [DataModelPropertyGuid("713597d3-8ab2-4f10-9df6-05c344a1b594")]
        public EmitterCustomShaderData EmitterCustomShaderData
        {
            get { return this.GetDataModelFromField(ref this.emitterCustomShaderData, false); }
            set { this.SetDataModelToField(ref this.emitterCustomShaderData, value); }
        }

        /// <summary>
        /// カスタムアクションです。
        /// </summary>
        [DataModelPropertyGuid("3165a827-8785-4f7e-9f87-51e9dd450f7a")]
        public CustomActionData CustomActionData
        {
            ////get { return this.GetDataModelFromField(ref this.customActionData, true); }
            ////set { this.SetDataModelToField(ref this.customActionData, value); }
            get { return this.customActionData; }
            set { this.customActionData = value; }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.EmitterBasicSettingData = srcDataModel.EmitterBasicSettingData;
            this.EmitterEmissionData = srcDataModel.EmitterEmissionData;
            this.EmitterEmitterData = srcDataModel.EmitterEmitterData;
            this.EmitterParticleData = srcDataModel.EmitterParticleData;
            this.EmitterCombinerData = srcDataModel.EmitterCombinerData;
            this.Textures = srcDataModel.Textures;
            this.EmitterColorData = srcDataModel.EmitterColorData;
            this.EmitterScaleData = srcDataModel.EmitterScaleData;
            this.EmitterRotationData = srcDataModel.EmitterRotationData;
            this.EmitterList = srcDataModel.EmitterList;
            this.FieldList = srcDataModel.FieldList;
            this.UserDataList = srcDataModel.UserDataList;
            this.StripeData = srcDataModel.StripeData;
            this.EmitterCustomShaderData = srcDataModel.EmitterCustomShaderData;
            this.CustomActionData = srcDataModel.CustomActionData;

            return true;
        }
    }
}
