﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;
using EffectMaker.DataModel.DataModels;

namespace NWCore.src.Remake.DataModel.DataModels.Emitter
{
    public class EmitterCustomShaderConvertingData : EmitterCustomShaderSettingData
    {
        public EmitterCustomShaderConvertingData()
        {
            this.Switches = new List<uint>();
            this.SwitchesVisibleList = new Dictionary<int, bool>();
            this.Params = new List<float>();
            this.ParamsVisibleList = new Dictionary<int, bool>();
        }

        public string Name { get; set; }
        public bool Visible { get; set; }

        public bool SwitchVisible { get; set; }
        public Dictionary<int, bool> SwitchesVisibleList { get; set; }

        public bool ParamVisible { get; set; }
        public Dictionary<int, bool> ParamsVisibleList { get; set; }

        public List<uint> Switches { get; set; }
        public List<float> Params { get; set; }
    }
}
