﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// アニメーションのループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorSettingsAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorSettingsAnimationData() :
            base()
        {
            this.LoopFrame = 100;
        }

        /// <summary>
        /// ループするか
        /// </summary>
        [DataModelPropertyGuid("46f0ba15-16c4-4e86-b322-bc72c410d52e")]
        public bool EnableLoop { get; set; }

        /// <summary>
        /// ループフレームです。
        /// </summary>
        [DataModelPropertyGuid("8d47b838-0ea9-4a84-be3c-be095e7907e3")]
        public int LoopFrame { get; set; }

        /// <summary>
        /// スタート位置ランダム
        /// </summary>
        [DataModelPropertyGuid("1d0a25ca-873d-4a7c-b068-83d310b47296")]
        public bool EnableStartRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterColorSettingsAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableLoop = srcDataModel.EnableLoop;
            this.LoopFrame = srcDataModel.LoopFrame;
            this.EnableStartRandom = srcDataModel.EnableStartRandom;

            return true;
        }
    }
}
