﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using System;
using System.Xml.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/乱数設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicRandomData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicRandomData() :
            base()
        {
            this.RandomType = 0;
            this.FixedRandomSeed = 1;
        }

        /// <summary>
        /// 乱数タイプです。
        /// </summary>
        [DataModelPropertyGuid("078dae7d-c0b0-4301-b263-694c782a195f")]
        public int RandomType { get; set; }

        /// <summary>
        /// 固定乱数値です。
        /// </summary>
        [DataModelPropertyGuid("7cf415c0-3e13-46b4-9a92-1e176d6cd758")]
        public int FixedRandomSeed { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as EmitterBasicRandomData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomType = srcDataModel.RandomType;
            this.FixedRandomSeed = srcDataModel.FixedRandomSeed;

            return true;
        }
    }
}
