﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// ユーザーデータ用データモデル
    /// </summary>
    public class UserData : BaseDataModel<UserData>
    {
        #region Properties

        /// <summary>
        /// uint へ変換したユーザーデータ
        /// </summary>
        public uint Data
        {
            get
            {
                uint data = 0;
                // ユーザースライダ
                data |= (uint)(this.UserSlider0 & 0x0ff);
                data |= (uint)((this.UserSlider1 & 0x0ff) << 8);
                // ユーザービット
                if (this.UserBit00) data |= ((uint)1 << 16);
                if (this.UserBit01) data |= ((uint)1 << 17);
                if (this.UserBit02) data |= ((uint)1 << 18);
                if (this.UserBit03) data |= ((uint)1 << 19);
                if (this.UserBit04) data |= ((uint)1 << 20);
                if (this.UserBit05) data |= ((uint)1 << 21);
                if (this.UserBit06) data |= ((uint)1 << 22);
                if (this.UserBit07) data |= ((uint)1 << 23);
                if (this.UserBit08) data |= ((uint)1 << 24);
                if (this.UserBit09) data |= ((uint)1 << 25);
                if (this.UserBit10) data |= ((uint)1 << 26);
                if (this.UserBit11) data |= ((uint)1 << 27);
                if (this.UserBit12) data |= ((uint)1 << 28);
                if (this.UserBit13) data |= ((uint)1 << 29);
                if (this.UserBit14) data |= ((uint)1 << 30);
                if (this.UserBit15) data |= ((uint)1 << 31);
                return data;
            }

            set
            {
                // ユーザースライダ
                this.UserSlider0 = (int)(value & 0x0ff);
                this.UserSlider1 = (int)((value >> 8) & 0x0ff);
                // ユーザービット
                this.UserBit00 = ((int)(value >> 16) & 1) != 0;
                this.UserBit01 = ((int)(value >> 17) & 1) != 0;
                this.UserBit02 = ((int)(value >> 18) & 1) != 0;
                this.UserBit03 = ((int)(value >> 19) & 1) != 0;
                this.UserBit04 = ((int)(value >> 20) & 1) != 0;
                this.UserBit05 = ((int)(value >> 21) & 1) != 0;
                this.UserBit06 = ((int)(value >> 22) & 1) != 0;
                this.UserBit07 = ((int)(value >> 23) & 1) != 0;
                this.UserBit08 = ((int)(value >> 24) & 1) != 0;
                this.UserBit09 = ((int)(value >> 25) & 1) != 0;
                this.UserBit10 = ((int)(value >> 26) & 1) != 0;
                this.UserBit11 = ((int)(value >> 27) & 1) != 0;
                this.UserBit12 = ((int)(value >> 28) & 1) != 0;
                this.UserBit13 = ((int)(value >> 29) & 1) != 0;
                this.UserBit14 = ((int)(value >> 30) & 1) != 0;
                this.UserBit15 = ((int)(value >> 31) & 1) != 0;
            }
        }

        /// <summary>
        /// uint へ変換したユーザーデータ
        /// </summary>
        public uint Data2
        {
            get
            {
                uint data = 0;
                // ユーザースライダ
                data |= (uint)( this.UserSlider2 & 0x0ff);
                data |= (uint)((this.UserSlider3 & 0x0ff) << 8);
                data |= (uint)((this.UserSlider4 & 0x0ff) << 16);
                data |= (uint)((this.UserSlider5 & 0x0ff) << 24);
                return data;
            }

            set
            {
                // ユーザースライダ
                this.UserSlider2 = (int)( value        & 0x0ff);
                this.UserSlider3 = (int)((value >> 8 ) & 0x0ff);
                this.UserSlider4 = (int)((value >> 16) & 0x0ff);
                this.UserSlider5 = (int)((value >> 24) & 0x0ff);
            }
        }

        #region User bits

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit00 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit01 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit02 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit03 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit04 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit05 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit06 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit07 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit08 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit09 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit10 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit11 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit12 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit13 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit14 { get; set; }

        /// <summary>
        /// ユーザービット
        /// </summary>
        public bool UserBit15 { get; set; }

        #endregion

        /// <summary>
        /// ユーザースライド０（0-255）
        /// </summary>
        public int UserSlider0 { get; set; }

        /// <summary>
        /// ユーザースライド１（0-255）
        /// </summary>
        public int UserSlider1 { get; set; }

        /// <summary>
        /// ユーザースライド2（0-255）
        /// </summary>
        public int UserSlider2 { get; set; }

        /// <summary>
        /// ユーザースライド3（0-255）
        /// </summary>
        public int UserSlider3 { get; set; }

        /// <summary>
        /// ユーザースライド4（0-255）
        /// </summary>
        public int UserSlider4 { get; set; }

        /// <summary>
        /// ユーザースライド5（0-255）
        /// </summary>
        public int UserSlider5 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF0 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF1 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF2 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF3 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF4 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF5 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF6 { get; set; }

        /// <summary>
        /// ユーザーデータ（float）
        /// </summary>
        public float UserDataF7 { get; set; }

        /// <summary>
        /// コールバックID (-1, 0-7)
        /// </summary>
        public int CallbackId
        {
            get;
            set;
        }

        #endregion

        #region Construtors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UserData()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="source"></param>
        public UserData(UserData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Data = (uint)0;
            this.Data2 = (uint)0;
            this.CallbackId = -1;
            this.UserDataF0 = 0.0f;
            this.UserDataF1 = 0.0f;
            this.UserDataF2 = 0.0f;
            this.UserDataF3 = 0.0f;
            this.UserDataF4 = 0.0f;
            this.UserDataF5 = 0.0f;
            this.UserDataF6 = 0.0f;
            this.UserDataF7 = 0.0f;
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(UserData source)
        {
            Ensure.Argument.NotNull(source);

            this.Data = source.Data;
            this.Data2 = source.Data2;
            this.UserDataF0 = source.UserDataF0;
            this.UserDataF1 = source.UserDataF1;
            this.UserDataF2 = source.UserDataF2;
            this.UserDataF3 = source.UserDataF3;
            this.UserDataF4 = source.UserDataF4;
            this.UserDataF5 = source.UserDataF5;
            this.UserDataF6 = source.UserDataF6;
            this.UserDataF7 = source.UserDataF7;
            this.CallbackId = source.CallbackId;
        }

        /// <summary>
        /// クローンします。
        /// </summary>
        public override UserData Clone()
        {
            return new UserData(this);
        }

        #endregion
    }
}
