﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace App.Global
{
    /// <summary>
    /// Class for mapping log message from other projects
    /// ( NWPtclConverter, NWCore, ...etc )
    /// to string table strings.
    /// </summary>
    public class LogMessageMapper
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public static void Init()
        {
            //AddEntry( ConverterMessages.PrimitiveHasNoTexCoord.ToString(), res.Strings.WARNING_PRIMITIVE_HAS_NO_TEXCOORD );
        }


        /// <summary>
        /// Map the specified string to registered target string.
        /// </summary>
        /// <param name="origMsg">The original string.</param>
        /// <returns>Mapped string.</returns>
        public static string Map( string origMsg )
        {
            uint iCRCValue = TheApp.CRC32Helper.ComputeCRC32Str(origMsg);
            if ( s_mappingTable.ContainsKey(iCRCValue)==false )
                return origMsg;

            return s_mappingTable[iCRCValue];
        }

        #region Private members

        /// <summary>
        /// Add an entry for mapping.
        /// </summary>
        /// <param name="origMsg">The original message.</param>
        /// <param name="mappedStr">The string should the original message be mapped to.</param>
        private static void AddEntry( string origMsg,
                                      string mappedStr )
        {
            uint iCRCValue = TheApp.CRC32Helper.ComputeCRC32Str( origMsg );
            if ( s_mappingTable.ContainsKey(iCRCValue)==true )
                System.Diagnostics.Debug.Assert( false, "App.Global.LogMessageMapper.AddEntry : The entry " + origMsg + " has already been added." );

            s_mappingTable.Add( iCRCValue, mappedStr );
        }


        private static Dictionary<uint, string> s_mappingTable = new Dictionary<uint, string>();

        #endregion
    }
}
