﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.DataModelMaker.UIControls.Interfaces
{
    /// <summary>
    /// Interface for data model editors.
    /// </summary>
    internal interface IDataModelEditor
    {
        /// <summary>
        /// Get or set the data source.
        /// </summary>
        object DataContext { get; set; }

        /// <summary>
        /// Confirm the edited contents and commit the modification to the data source.
        /// </summary>
        /// <returns>
        /// False if there are problems in the modifications and should cancel the action.
        /// </returns>
        bool CommitEditing();

        /// <summary>
        /// Cancel the edited contents.
        /// </summary>
        /// <param name="deleteContents">True to delete the editing contents.</param>
        void CancelEditing(bool deleteContents);
    }
}
