﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace EffectMaker.DataModelMaker.Core.Definitions
{
    /// <summary>
    /// Class to hold all the data in the workspace.
    /// </summary>
    [XmlType("WorkspaceDefinition")]
    public class WorkspaceDefinition : DefinitionBase
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public WorkspaceDefinition()
        {
            this.FilePath = string.Empty;
            this.EditorDataModelDefinition = null;
            this.RuntimeDataModelDefinition = null;
        }

        /// <summary>
        /// Get or set the file path of the workspace.
        /// </summary>
        [XmlIgnore]
        public string FilePath { get; set; }

        /// <summary>
        /// Get or set the file path of the editor data model definition.
        /// </summary>
        [XmlElement("EditorDataModelDefinition")]
        public string EditorDataModelDefinitionFilePath { get; set; }

        /// <summary>
        /// Get or set the file path of the runtime data model definition.
        /// </summary>
        [XmlElement("RuntimeDataModelDefinition")]
        public string RuntimeDataModelDefinitionFilePath { get; set; }

        /// <summary>
        /// Get or set the editor data model definitions.
        /// </summary>
        [XmlIgnore]
        public EditorDataModelRootDefinition EditorDataModelDefinition { get; set; }

        /// <summary>
        /// Get or set the runtime data model definitions.
        /// </summary>
        [XmlIgnore]
        public RuntimeDataModelRootDefinition RuntimeDataModelDefinition { get; set; }

        /// <summary>
        /// Dispose the definition.
        /// </summary>
        public override void Dispose()
        {
            if (this.EditorDataModelDefinition != null)
            {
                this.EditorDataModelDefinition.Dispose();
                this.EditorDataModelDefinition = null;
            }

            if (this.RuntimeDataModelDefinition != null)
            {
                this.RuntimeDataModelDefinition.Dispose();
                this.RuntimeDataModelDefinition = null;
            }

            base.Dispose();
        }
    }
}
