﻿// ========================================================================
// <copyright file="IChildObject.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// 親を持つオブジェクトのインターフェースです。
    /// </summary>
    public interface IChildObject
    {
        /// <summary>
        /// 親を取得または設定します。
        /// 親を再設定する場合、一度 null を設定してクリアしてください。
        /// </summary>
        object Parent { get; set; }
    }

    /// <summary>
    /// 親を持つオブジェクトのインターフェースです。
    /// </summary>
    /// <typeparam name="TParent">親のテンプレート型です。</typeparam>
    public interface IChildObject<TParent> : IChildObject
        where TParent : class
    {
        /// <summary>
        /// 親を取得または設定します。
        /// 親を再設定する場合、一度 null を設定してクリアしてください。
        /// </summary>
        new TParent Parent { get; set; }
    }
}
