﻿// ========================================================================
// <copyright file="MetaDataUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    /// <summary>
    /// メタデータのユーティリティクラスです。
    /// </summary>
    public static class MetaDataUtility
    {
        /// <summary>
        /// 名前でメタデータを取得します。
        /// </summary>
        /// <param name="editDataSet">メタデータセットです。</param>
        /// <param name="key">名前です。</param>
        /// <returns>メタデータです。</returns>
        public static IMetaData GetByKey(
            this IEnumerable<IMetaData> editDataSet, string key)
        {
            // キーは重複しないはずです。
            return editDataSet.SingleOrDefault((editData) => editData.Key == key);
        }

        /// <summary>
        /// 型でメタデータを取得します。
        /// </summary>
        /// <typeparam name="TType">型です。</typeparam>
        /// <param name="editDataSet">メタデータセットです。</param>
        /// <returns>メタデータです。</returns>
        public static IEnumerable<IMetaData> GetByType<TType>(
            this IEnumerable<IMetaData> editDataSet)
        {
            return editDataSet.Where((editData) => editData is TType);
        }

        /// <summary>
        /// 名前でメタデータを取得します。
        /// </summary>
        /// <param name="editDataSet">メタデータセットです。</param>
        /// <param name="key">名前です。</param>
        /// <returns>メタデータです。</returns>
        public static bool TryRemoveByKey(
            this IList<IMetaData> editDataSet, string key)
        {
            // キーは重複しないはずです。
            var target = editDataSet.SingleOrDefault((editData) => editData.Key == key);
            if (target != null)
            {
                editDataSet.Remove(target);
                return true;
            }

            return false;
        }
    }
}
