﻿// ========================================================================
// <copyright file="GenericMetaData.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using NintendoWare.ToolDevelopmentKit.ComponentModel;

    /// <summary>
    /// 任意のクラスのインスタンスを1つ保有するメタデータです。
    /// 保有するインスタンスは、GenericMetaDataValueを継承している必要があります。
    /// </summary>
    public sealed class GenericMetaData : ObservableObject, IMetaData
    {
        private string key = string.Empty;
        private GenericMetaDataValue value = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public GenericMetaData()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">コピー元のインスタンスです。</param>
        private GenericMetaData(GenericMetaData source)
        {
            this.Set(source);
        }

        /// <summary>
        /// データを検索する際のキーワードです。
        /// </summary>
        public string Key
        {
            get
            {
                return this.key;
            }

            set
            {
                Ensure.Argument.NotNull(value);

                this.key = value;
                OnPropertyChanged("Key");
            }
        }

        /// <summary>
        /// 保有するインスタンスです。
        /// </summary>
        public GenericMetaDataValue Value
        {
            get
            {
                return this.value;
            }

            set
            {
                Ensure.Argument.NotNull(value);

                this.value = value;
                OnPropertyChanged("Value");
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public object Clone()
        {
            return new GenericMetaData(this);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            this.Set(source as GenericMetaData);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        private void Set(GenericMetaData source)
        {
            Ensure.Argument.NotNull(source);

            this.Key = source.Key;

            // TODO: shallow copyで問題ないか？
            this.Value = source.Value;
        }
    }
}
