﻿// ========================================================================
// <copyright file="EditTagMetaDataXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System.Collections.Generic;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit.Collections;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 編集ツール用文字列タグデータのシリアライズ用クラスです。
    /// </summary>
    public abstract class EditTagMetaDataXml : EditMetaDataXml
    {
        //----------------------------------------------------------
        // コンストラクタ
        //----------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public EditTagMetaDataXml()
        {
            this.Values = new List<string>();
        }

        //----------------------------------------------------------
        // プロパティ
        //----------------------------------------------------------

        /// <summary>
        /// ユーザデータの要素数を取得または設定します。
        /// </summary>
        [XmlAttribute]
        public int Size
        {
            get
            {
                return this.Values.Count;
            }

            set
            {
                // なにもしません。
            }
        }

        /// <summary>
        /// タグ文字列のリストを取得または設定します。
        /// </summary>
        [Overwrite(OverwriteAttribute.KindType.ListSet)]
        public List<string> Values { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public override void Set(object source)
        {
            this.Set(source as EditMetaDataXml);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        protected void Set(EditTagMetaDataXml source)
        {
            Ensure.Argument.NotNull(source);
            ListUtility.Copy(source.Values, this.Values);
        }
    }
}
