﻿// ========================================================================
// <copyright file="ObservableNamedObject.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.ComponentModel
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 通知機能が付いた名前付きオブジェクトです。
    /// </summary>
    public class ObservableNamedObject : ObservableObject, INamedObject
    {
        //-----------------------------------------------------------------
        private string name = string.Empty;

        /// <summary>
        /// 名前を取得または設定します。
        /// 初期値は空文字列であり、null は設定できません。
        /// </summary>
        public virtual string Name
        {
            get
            {
                return this.name;
            }

            set
            {
                Ensure.Argument.NotNull(value);

                this.name = value;
                OnPropertyChanged("Name");
            }
        }
    }
}
