﻿// ========================================================================
// <copyright file="EnumerableUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections;

    /// <summary>
    /// 列挙可能なコレクション用ユーティリティ
    /// </summary>
    public static class EnumerableUtility
    {
        /// <summary>
        /// 列挙可能なコレクションが空ではないか確認します。
        /// </summary>
        /// <param name="argument">コレクションです。</param>
        /// <returns>空でなければ true を返します。</returns>
        public static bool NotEmpty(IEnumerable argument)
        {
            Ensure.Argument.NotNull(argument);

            int count = 0;
            foreach (object each in argument)
            {
                Ensure.Argument.True(each != null);
                count++;
            }

            return count != 0;
        }
    }
}
