﻿namespace NWCore.DataModel
{
    /// <summary>
    /// ベクトルのインターフェースです。
    /// </summary>
    public interface IVectori
    {
        /// <summary>
        /// 次元数を取得します。
        /// </summary>
        int Dimension { get; }

        /// <summary>
        /// 指定したインデックス位置の成分を取得します。
        /// </summary>
        /// <param name="i">インデックスです。</param>
        /// <returns>成分です。</returns>
        int this[int i] { get; set; }

        /// <summary>
        /// 座標を格納した配列を返します。
        /// </summary>
        /// <returns>座標の配列です。</returns>
        int[] ToArray();

        /// <summary>
        /// 成分を 0 に設定します。
        /// </summary>
        void SetZero();

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        void Set(object source);

        /// <summary>
        /// 成分を指定の値に設定します。
        /// </summary>
        /// <param name="source">成分の配列です。</param>
        void Set(int[] source);
    }
}
