﻿// ========================================================================
// <copyright file="FieldSpinData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_1.Build_0.Revision_0
{
    /// <summary>
    /// スピンフィールド
    /// </summary>
    public sealed class FieldSpinData : BaseDataModel<FieldSpinData>
    {
        #region Properties

        /// <summary>
        /// 回転力
        /// </summary>
        public int FieldSpinRotation
        {
            get;
            set;
        }

        /// <summary>
        /// 軸
        /// </summary>
        public int FieldSpinAxis
        {
            get;
            set;
        }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldSpinData()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldSpinData(FieldSpinData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.FieldSpinAxis = 1;
            this.FieldSpinRotation = 0;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FieldSpinData source)
        {
            Ensure.Argument.NotNull(source);

            this.FieldSpinRotation = source.FieldSpinRotation;
            this.FieldSpinAxis = source.FieldSpinAxis;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldSpinData Clone()
        {
            return new FieldSpinData(this);
        }

        #endregion
    }
}
