﻿// ========================================================================
// <copyright file="ColorLabelTable.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System.Diagnostics;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.Serializer.Major_1.Minor_1.Build_0.Revision_0;

namespace NWCore.DataModel.Major_1.Minor_1.Build_0.Revision_0
{
    /// <summary>
    /// カラーラベルテーブル
    /// </summary>
    public static class ColorLabelTable
    {
        static RgbaColor CreateColor(byte r, byte g, byte b)
        {
            return new RgbaColor(
                ((float)r / 255.0f), ((float)g / 255.0f), ((float)b / 255.0f), 1.0f);
        }

        /// <summary>
        /// カラーテーブル
        /// </summary>
        public static readonly RgbaColor[] ColorTable = new RgbaColor[]
        {
            /*
             * http://www-sdd.zelda.nintendo.co.jp/project/nintendoware3/kagemai/html/user.cgi?project=nw3_eft&action=view_report&id=274#6
                無　= ラベルカラーなし
                赤 = 232,196,190
                橙 = 242,215,174
                黄 = 242,240,174
                緑 = 209,226,180
                青 = 208,219,236
                紫 = 219,210,229
                灰 = 224,224,224
             */
            CreateColor(255,255,255),
            CreateColor(232,196,190),
            CreateColor(242,215,174),
            CreateColor(242,240,174),
            CreateColor(209,226,180),
            CreateColor(208,219,236),
            CreateColor(219,210,229),
            CreateColor(224,224,224),
        };

        /// <summary>
        /// テーブルの要素数
        /// </summary>
        public static int Count
        {
            get { return ColorTable.Length; }
        }

        /// <summary>
        /// デフォルトのカラーインデックス
        /// </summary>
        public const int DefaultColorIndex = 0;

        /// <summary>
        /// デフォルトのカラー
        /// </summary>
        public static RgbaColor DefaultColor
        {
            get { return ColorTable[DefaultColorIndex]; }
        }

        /// <summary>
        /// カラーインデックス → カラーデータ
        /// </summary>
        /// <remarks>
        /// カラーテーブルを超えるインデックスを指定した場合は全てDefaultColorになります。
        /// </remarks>
        public static RgbaColor GetColor(int colorIndex)
        {
            if (Count > colorIndex)
            {
                return ColorTable[colorIndex];
            }
            return DefaultColor;
        }
    }
}

