﻿// ========================================================================
// <copyright file="RegexMatch.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Text.RegularExpressions;

namespace App.Utility
{
    /// <summary>
    /// 正規表現一致確認クラス。
    /// </summary>
    public sealed class RegexMatch
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        private RegexMatch() {}

        /// <summary>
        /// 正規表現に一致するかを確認。
        /// </summary>
        public static bool Check(string input, string pattern)
        {
            return Check(input, new Regex(pattern));
        }

        /// <summary>
        /// 正規表現に一致するかを確認。
        /// </summary>
        public static bool Check(string input, Regex regex)
        {
            Match match = regex.Match(input);
            return match.Success && match.Length == input.Length;
        }
    }
}
