﻿// ========================================================================
// <copyright file="PointUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;

namespace App.Utility

{
    /// <summary>
    /// ポイントユーティリティクラス。
    /// </summary>
    public static class PointUtility
    {
        /// <summary>
        /// ２点間の距離を取得。
        /// </summary>
        public static float GetDistance(PointF pt1, PointF pt2)
        {
            return (float)Math.Sqrt(
                (pt2.X - pt1.X) * (pt2.X - pt1.X) + (pt2.Y - pt1.Y) * (pt2.Y - pt1.Y));
        }

        /// <summary>
        /// POINT型に変換。
        /// </summary>
        public static Win32.POINT ToPOINT(Point pt)
        {
            Win32.POINT result = new Win32.POINT();
            result.x = pt.X;
            result.y = pt.Y;
            return result;
        }
    }
}
