﻿// ========================================================================
// <copyright file="DocumentsOpener.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
//using App.Command;
using App.Data;
using App.Utility;
using NWCore.Viewer;
using NWCore.DataModel;
using System.Collections.Generic;

namespace App.IO
{
    /// <summary>
    /// ドキュメンツオープナ。
    /// </summary>
    public sealed class DocumentsOpener
    {
        // ファイルフィルタのインデックス
        private static int _fileFilterIndex = -1;

        /// <summary>
        /// 開く
        /// </summary>
        public bool Open()
        {
            // フィルタ文字列作成
            string filter = res.Strings.IO_FILEFILTER_CAFE_ALL;
            filter += "|" + res.Strings.IO_FILEFILTER_CAFE_ESET;
            filter += "|" + res.Strings.IO_FILEFILTER_CAFE_FENV;
            filter += "|" + res.Strings.IO_FILEFILTER_CAFE_PREV;
            //filter += "|" + res.Strings.IO_FILEFILTER_CTR_CMDL;
            //filter += "|" + res.Strings.IO_FILEFILTER_CTR_CPTL;
            //filter += "|" + res.Strings.IO_FILEFILTER_CTR_CTEX;
            //filter += "|" + res.Strings.IO_FILEFILTER_CTR_CRES;

            // ダイアログ表示
            OpenFileDialog dialog = CreateDialog(filter);
            if (_fileFilterIndex != -1)
            {
                dialog.FilterIndex = _fileFilterIndex;
            }
            bool result = ShowDialog(dialog);
            if (result)
            {
                _fileFilterIndex = dialog.FilterIndex;
            }
            return result;
        }

        /// <summary>
        /// Open emitter set file and load it as a template.
        /// </summary>
        /*
        public bool OpenTemplateFile()
        {
            #region Pick the emitter set file to open as template

            // Compose filter string for the dialog.
            string filter = res.Strings.IO_FILEFILTER_CAFE_ESET;

            string filePath = null;

            MainFrame.SynchronizationContext.Send(() =>
            {
                // Create the file open dialog.
                OpenFileDialog fileDialog = new OpenFileDialog();

                // Setup the file open dialog.
                fileDialog.Filter = filter;
                fileDialog.Multiselect = false;
                fileDialog.InitialDirectory = Config.Data.DocumentIO.GetLastAccessedDir(DocumentConstants.TemplateTypeKey);
                fileDialog.FilterIndex = 0;
                fileDialog.AutoUpgradeEnabled = Config.Data.DocumentIO.AutoUpgradeEnabled;

                // Show the file open dialog.
                if (fileDialog.ShowDialog(TheApp.MainFrame) != DialogResult.OK)
                {
                    // User canceled, bale out.
                    return;
                }

                // Get the selected file path from the file open dialog.
                filePath = fileDialog.FileName;
            });

            if (filePath == null)
                return true;

            // Set the selected directory path to the config.
            Config.Data.DocumentIO.SetLastAccessedDir( DocumentConstants.TemplateTypeKey,
                                                       filePath );

            string name = Path.GetFileNameWithoutExtension(filePath);
            if (name.Length > DocumentIO.s_MaxFileNameLength)
            {
                DocumentIO.ErrorFileNameLengthLoad(filePath);
                return false;
            }

            #endregion

            #region Load emitter set from the selected file

            // Load the emitter set.
            EmitterSetDocument emitterSetDoc =
                DocumentIO.LoadEmitterSetFile( filePath, null );
            if ( emitterSetDoc==null )
                return false;

            #endregion

            #region Show template dialog

            OpenTemplateDialog.TemplateEmitterData[] createdEmitters = null;

            MainFrame.SynchronizationContext.Send(() =>
            {
                OpenTemplateDialog templateDialog = new OpenTemplateDialog(emitterSetDoc);

                if (templateDialog.ShowDialog(TheApp.MainFrame) != DialogResult.OK)
                    return;

                // Get the emitter information which created from the loaded template.
                createdEmitters = templateDialog.CreatedEmitters;
            });

            #endregion

            #region Process loaded templates

            if (createdEmitters == null || createdEmitters.Length <= 0)
                return true;

            // We need to group up the commands for different command stacks.
            Dictionary<IDocument, CommandSet> commandGroups =
                new Dictionary<IDocument, CommandSet>();

            // Get the active project document.
            string           projectName = string.Empty;
            IProjectDocument project     = ProjectManager.ActiveProject;
            if ( project==null )
            {
                // Get the default project name.
                projectName = DocumentCreator.CreateDefaultProjectName();

                // Create the default project.
                TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                    new EffectProjectCreationCommand( projectName ) );

                // Get the created project.
                project = ProjectManager.ActiveProject;
            }
            else
            {
                projectName = project.Name;
            }

            // Disable the rebuild of the project tree for now.
            bool bShouldTurnRebuildBackOn = false;
            if ( project!=null &&
                 project.EnableBuildTreeNodes==true )
            {
                project.EnableBuildTreeNodes = false;
                bShouldTurnRebuildBackOn     = true;
            }

            #region Create the emitters from the loaded template

            // The emitters are actually created here.
            foreach ( OpenTemplateDialog.TemplateEmitterData data in createdEmitters )
            {
                if ( data==null ||
                     data.EmitterDocument==null ||
                     data.ParentEmitterSet==null )
                {
                    continue;
                }

                // Get the emitter document from the template data.
                EmitterDocument template = data.EmitterDocument as EmitterDocument;
                if ( template==null )
                    continue;

                // Get the owner emitter set data.
                OpenTemplateDialog.EmitterSetData emitterSetData = data.ParentEmitterSet;

                // Get the emitter set document.
                EmitterSetDocument parentDoc =
                    emitterSetData.EmitterSet as EmitterSetDocument;
                if ( parentDoc==null )
                    continue;

                // This emitter set was from the template file instead of the
                // project, so we'll have to create the emitter set first.
                if ( emitterSetData.FromTemplate==true )
                {
                    // Duplicate the template emitter set with the new name.
                    parentDoc = parentDoc.DuplicateSelf( emitterSetData.Name,
                                                         project,
                                                         true ) as EmitterSetDocument;

                    // Add the command to the command set for later execution.
                    TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                        new EmitterSetDocumentAddRemoveCommand( parentDoc,
                                                                null,
                                                                EmitterSetDocumentAddRemoveCommand.OpFlg.Add ) );

                    // Set the created emitter set back to the data holder.
                    emitterSetData.EmitterSet   = parentDoc;
                    emitterSetData.FromTemplate = false;
                }

                // Create default game settings document for the emitter set.
                if ( parentDoc.GetNumGameSettingsDocuments()<=0 )
                {
                    string docName =
                        DocumentCreator.CreateDefaultGameSettingsDocName( parentDoc );

                    TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                        new GameSettingsDocumentCreationCommand( docName, parentDoc ) );
                }

                // Duplicate the template emitter document with the new name.
                EmitterDocument doc = template.Duplicate( data.Name, parentDoc );

                // Find the right command set to add this command.
                CommandSet commandSet;
                if ( commandGroups.TryGetValue( parentDoc, out commandSet )==false )
                {
                    // We need a new command set, create it.
                    commandSet = new CommandSet( true );

                    // Add the command set to our list.
                    commandGroups.Add( parentDoc, commandSet );
                }

                // Add the emitter document to the emitter set.
                commandSet.Add( new EmitterDocumentAddCommand( parentDoc,
                                                               doc ) );
            }

            #endregion

            // Execute the command set.
            Dictionary< IDocument, CommandSet >.Enumerator enumerator = commandGroups.GetEnumerator();
            while ( enumerator.MoveNext()==true )
            {
                KeyValuePair< IDocument, CommandSet > pair = enumerator.Current;

                // Execute the command set with the target command stack ( document ).
                TheApp.CommandManager.BeginCommandSet( pair.Key, pair.Value );
                TheApp.CommandManager.EndCommandSet( false );
            }

            // Turn on the rebuild of the project tree again.
            if ( bShouldTurnRebuildBackOn==true )
                project.EnableBuildTreeNodes = true;

            // Rebuild the project tree.
            project.BuildTreeNodes();

            #endregion

            // Send the emitter set to the viewer
            Viewer.Message.SendUtility.SendAll();

            return true;
        }
        */

        /// <summary>
        /// ダイアログの作成。
        /// </summary>
        public OpenFileDialog CreateDialog(string filter)
        {
            return null;

            /*
            OpenFileDialog dialog = MainFrame.SynchronizationContext.SafelyProduce(() =>
                new OpenFileDialog
                {
                    Filter = filter,
                    Multiselect = true,
                    InitialDirectory = Config.Data.DocumentIO.GetLastAccessedDir(DocumentConstants.Eset),
                    FilterIndex = 0,
                    AutoUpgradeEnabled = Config.Data.DocumentIO.AutoUpgradeEnabled,
                });
            return dialog;
            */
        }

        /// <summary>
        /// ダイアログの表示。
        /// </summary>
        public bool ShowDialog(OpenFileDialog dialog)
        {
            /*
            if (MainFrame.SynchronizationContext.SafelyProduce(() => dialog.ShowDialog(TheApp.MainFrame)) == DialogResult.OK)
            {
                Application.DoEvents();
                Open(dialog.FileNames);

                // make WaitTransmission to run on the UI thread
                MainFrame.SynchronizationContext.Send(() => MCSManager.WaitTransmission());
                Config.Data.DocumentIO.SetLastAccessedDir( DocumentConstants.Eset,
                                                           dialog.FileName );
                return true;
            }
            */
            return false;
        }

        /// <summary>
        /// 開く。
        /// </summary>
        public bool Open(string[] filePaths)
        {
            //MainFrame.SynchronizationContext.Send( () => DocumentManager.NotifyBeginDocLoading() );

            DocumentComponentChangedEventArgs changed = new DocumentComponentChangedEventArgs();
            bool result = Open(filePaths, changed);
            Document.NotifyComponentChanged(this, changed);

            //MainFrame.SynchronizationContext.Send( () => DocumentManager.NotifyEndDocLoading() );

            return result;
        }

        /// <summary>
        /// 開く。
        /// </summary>
        public bool Open(string[] filePaths, DocumentComponentChangedEventArgs changed)
        {
            Debug.Assert(filePaths != null);
            if (filePaths.Length == 0) { return true; }
            PathList pathList = new PathList(filePaths);

            // 無効なファイルがあれば警告
            if (pathList.InvalidList.Count > 0)
            {
                foreach (string filePath in pathList.InvalidList)
                {
                    MessageLogger.WriteWarningRes("IO_UNKNOWN_FORMAT_MSG", Path.GetFileName(filePath));
                }
            }

            bool result = true;
            using (WaitCursor wait = new WaitCursor())
            {
                // Workspaceの読み込み。
                if ( OpenEnvConfigFile(pathList, changed)==false )
                {
                    result = false;
                }
                // EmitterSetの読み込み
                if ( OpenEmitterSet(pathList, changed)==false )
                {
                    result = false;
                }
                // プレビューファイルの読み込み
                if ( OpenPreviewFile(pathList, changed)==false)
                {
                    result = false;
                }
            }

            return result;
        }

        /// <summary>
        /// エミッタセットの読み込み。
        /// </summary>
        private bool OpenEmitterSet(PathList filePaths,
                                    DocumentComponentChangedEventArgs changed)
        {
            bool result = true;
            EffectProjectDocument project = ProjectManager.ActiveProject as EffectProjectDocument;

            if (project == null && ProjectManager.Projects.Count > 0)
                project = ProjectManager.Projects[0] as EffectProjectDocument;

            foreach (string filePath in filePaths.EmitterSetList)
            {
                string name = Path.GetFileNameWithoutExtension(filePath);
                if (name.Length > DocumentIO.s_MaxFileNameLength)
                {
                    DocumentIO.ErrorFileNameLengthLoad(filePath);
                    continue;
                }

                EmitterSetDocument esetDoc = null;
                try
                {
                    if (project == null)
                    {
                        string defName = DocumentCreator.CreateDefaultProjectName();

                        // Create a project.
                        //TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                        //    new EffectProjectCreationCommand( defName ) );

                        // Get the created project document.
                        project = ProjectManager.ActiveProject as EffectProjectDocument;

                        // Load the emitter set from file
                        esetDoc = DocumentIO.LoadEmitterSetFile( filePath, project );

                        // Create the emitter set doc
                        /*
                        TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                            new EmitterSetDocumentAddRemoveCommand(
                                esetDoc, null,
                                EmitterSetDocumentAddRemoveCommand.OpFlg.Add ) );
                        */
                    }
                    else
                    {
                        if ( project.FindByName(name)!=null )
                        {
                            // 同時に読み込んでいるリストのこのファイルがあるときは、何もエラーをださい。

                            // 同名ファイルがあるとき
                            DocumentIO.ErrorFileNameCollision(filePath);
                            continue;
                        }
                        esetDoc = DocumentIO.LoadEmitterSetFile(filePath, project);

                        if ( esetDoc!=null )
                        {
                            // 正常に読み込めたとき
                            /*
                            TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                                new EmitterSetDocumentAddRemoveCommand(
                                    esetDoc, project,
                                    EmitterSetDocumentAddRemoveCommand.OpFlg.Add));

                            // 送信
                            Viewer.Message.SendUtility.SendEmitterSetBinary( esetDoc );
                            */
                        }
                        else
                        {
                            // エラーのとき
                        }
                    }
                }
                catch (Exception ex)
                {
                    DebugConsole.WriteLine(ex.Message);
                    Trace.WriteLine(ex.Message);
                    result = false;
                }

                if ( esetDoc!=null )
                {
                    // Create default game settings document
                    string defName =
                        DocumentCreator.CreateDefaultGameSettingsDocName( esetDoc );

                    /*
                    TheApp.CommandManager.ExecuteIgnoreTargetDocument(
                        new GameSettingsDocumentCreationCommand( defName, esetDoc ) );
                    */

                    ProjectManager.ActiveDocument = esetDoc;
                }
            }

            return result;
        }

        /// <summary>
        /// エディット環境ファイルの読み込み。
        /// </summary>
        private bool OpenEnvConfigFile(PathList filePaths,
                                       DocumentComponentChangedEventArgs changed)
        {
            if ( filePaths.FenvConfigList==null ||
                 filePaths.FenvConfigList.Count<=0 )
            {
                return false;
            }

            EffectProjectDocument project =
                ProjectManager.ActiveProject as EffectProjectDocument;

            if ( project==null )
            {
                // Bail out if there aren't any projects.
                if ( ProjectManager.Projects.Count<=0 )
                    return false;

                project = ProjectManager.Projects[0] as EffectProjectDocument;
            }

            // Loading multiple workspace is pointless, so we only load the first one on the list.
            string filePath = filePaths.FenvConfigList[0];
            string fileName = Path.GetFileNameWithoutExtension( filePath );

            if ( fileName.Length>DocumentIO.s_MaxFileNameLength )
            {
                DocumentIO.ErrorFileNameLengthLoad( fileName );
                return false;
            }

            // There are too many UI updates while loading the workspace,
            // just use the main thread to load it.
            //return MainFrame.SynchronizationContext.SafelyProduce( () => DocumentIO.Command_FileEnvLoad(project, filePath) );
            return false;
        }

        /// <summary>
        /// プレビューファイルの読み込み。
        /// </summary>
        private bool OpenPreviewFile( PathList filePaths,
                                      DocumentComponentChangedEventArgs changed )
        {
            bool result = true;

            EffectProjectDocument project =
                ProjectManager.ActiveProject as EffectProjectDocument;

            if ( project==null &&
                 ProjectManager.Projects.Count>0 )
            {
                project = ProjectManager.Projects[0] as EffectProjectDocument;
            }

            // プロジェクトが存在しない
            if ( project==null )
                return false;

            List<string> emitterSetList = new List<string>();
            foreach ( string filePath in filePaths.PreviewFileList )
            {
                string name = Path.GetFileNameWithoutExtension(filePath);
                if (name.Length > DocumentIO.s_MaxFileNameLength)
                {
                    DocumentIO.ErrorFileNameLengthLoad(filePath);
                    continue;
                }

                DocumentIO.Command_FilePrevLoad(project, filePath, emitterSetList);
            }

            // 一緒に読み込んだエミッタセットは、読み込む予定のエミッタセットから削除する
            if (emitterSetList.Count > 0 && filePaths.EmitterSetList.Count > 0)
            {
                List<string> removeList = new List<string>();
                foreach (string path in emitterSetList)
                {
                    string fullPath = Path.GetFullPath(path);
                    foreach (string item in filePaths.EmitterSetList)
                    {
                        if (Path.GetFullPath(item).Equals(fullPath, StringComparison.InvariantCultureIgnoreCase))
                        {
                            removeList.Add(item);
                            break;
                        }
                    }
                }
                foreach (string item in removeList)
                {
                    filePaths.EmitterSetList.Remove(item);
                }
            }

            return result;
        }
    }
}
