﻿// ========================================================================
// <copyright file="MenuCommandID.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace App
{
    /// <summary>
    /// メニューコマンドＩＤ。
    /// </summary>
    public enum MenuCommandID
    {
        /// <summary></summary>
        FileNewProject,
        /// <summary></summary>
        FileNewEmitterSet,
        /// <summary></summary>
        FileNewEmitter,
        /// <summary></summary>
        FileNewPreview,
        /// <summary></summary>
        FileOpen,
        /// <summary></summary>
        FileRecentFilesRoot,
        /// <summary></summary>
        FileRecentFilesItem,
        /// <summary></summary>
        FileRecentFilesClear,
        /// <summary></summary>
        TemplateOpen,

        /// <summary></summary>
        FileEnvLoad,
        /// <summary></summary>
        FileEnvSave,
        /// <summary></summary>
        FileEnvSaveAs,

        /// <summary></summary>
        FileClose,
        /// <summary></summary>
        FileCloseModelSet,
        /// <summary></summary>
        FileCloseAll,
        /// <summary></summary>
        FileCloseSelection,
        /// <summary></summary>
        FileSave,
        /// <summary></summary>
        FileSaveAs,
        /// <summary></summary>
        FileSaveAll,
        /// <summary></summary>
        FileSaveAllTo,
        /// <summary></summary>
        FileSaveBinary,
        /// <summary></summary>
        FileRename,
        /// <summary></summary>
        FileExit,
        /// <summary></summary>
        EditUndo,
        /// <summary></summary>
        EditRedo,

        /// <summary></summary>
        ViewProperty,
        /// <summary>Effect browser</summary>
        ViewEffectBrowser,
        /// <summary></summary>
        ViewHistory,
        /// <summary></summary>
        ViewToolBar,
        /// <summary></summary>
        ViewStatusBar,

        /// <summary></summary>
        PreviewChangeConnection,
        /// <summary></summary>
        SendBinaryAgain,

        /// <summary></summary>
        ToolOption,
        /// <summary></summary>
        HelpHelp,
        /// <summary></summary>
        HelpViewer,
        /// <summary></summary>
        HelpOverview,
        /// <summary></summary>
        HelpGlossary,
        /// <summary></summary>
        HelpTips,
        /// <summary></summary>
        HelpAbout,

        /// <summary></summary>
        DebugDefSetup,
        /// <summary></summary>
        DebugGoto,
        /// <summary></summary>
        DebugChez,
        /// <summary></summary>
        DebugTanaka,
    }
}
