﻿// ========================================================================
// <copyright file="FluctuationDocument.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
//using App.Command;
using App.IO;
//using App.PropertyEdit;
using NWCore.DataModel;

namespace App.Data
{
    /// <summary>
    /// パーティクル・セット用ドキュメント
    /// </summary>
    public sealed class FluctuationDocument : BaseProjectPanelDocument
    {
        #region Memeber Variables

        private EmitterDocument m_emitterDoc = null; // parent/owner

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド
        /// </summary>
        public override GuiObjectID ObjectID
        {
            get { return GuiObjectID.Fluctuation; }
        }

        /// <summary>
        /// 名前
        /// </summary>
        public override string Name
        {
            get
            {
                return res.Strings.FLUCTUATION_DEFAULT_NAME;
            }
            set
            {
            }
        }

        /// <summary>
        /// オーナードキュメント
        /// </summary>
        public override IDocument OwnerDocument
        {
            get { return this.EmitterDocument; }
        }

        /// <summary>
        /// emitter set this emitter belongs to
        /// </summary>
        public EmitterDocument EmitterDocument
        {
            get { return this.m_emitterDoc; }
            set { this.m_emitterDoc = value; }
        }

        /// <summary>
        /// accessor for field data model encapsulated in this document
        /// </summary>
        public FluctuationData FluctuationData
        {
            get { return this.EmitterDocument.EmitterData.FluctuationData; }
            set { this.EmitterDocument.EmitterData.FluctuationData = value; }
        }

        /// <summary>
        /// アイコンイメージのキーです
        /// </summary>
        public override string ImageKey
        {
            get
            {
                string baseName = this.ObjectID.ToString();
                string activeKey = this.EmitterDocument.EmitterData.FluctuationFlag.Enable ? Document.ActiveIconKey : Document.NonactiveIconKey;
                return baseName + activeKey;
            }
        }

        /// <summary>
        /// data source path without data model
        /// </summary>
        public override string RelativeDataScrPath
        {
            get
            {
                return this.EmitterDocument.RelativeDataScrPath + ".FluctuationData";
            }
        }

        /// <summary>
        /// path of the data source
        /// </summary>
        public override string DataScrPath
        {
            get
            {
                return this.EmitterDocument.DataScrPath;
            }
        }

        #endregion

        #region Constructors

        /// <summary>
        /// コンストラクタ（エフェクト用）
        /// </summary>
        public FluctuationDocument(EmitterDocument emitterDoc)
            : base(res.Strings.FLUCTUATION_DEFAULT_NAME)
        {
            this.Name = res.Strings.FLUCTUATION_DEFAULT_NAME;
            this.m_emitterDoc = emitterDoc;
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// notify property has been changed
        /// </summary>
        public void NotifyPropertyChanged()
        {
            ProjectManager.UpdateAll();
        }

        #endregion
    }
}
