﻿/*---------------------------------------------------------------------------*
 Copyright (C) 2013 Nintendo Co., Ltd.  All rights reserved.

 These coded instructions, statements, and computer programs contain
 proprietary information of Nintendo of America Inc. and/or Nintendo
 Company Ltd., and are protected by Federal copyright law.  They may
 not be disclosed to third parties or copied or duplicated in any form,
 in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#define _USE_NN_VFX                             1   // vfx であることの表明
#define _TARGET_NVN                             1   // [開発者は使用禁止] ユーザーコードでの実装分岐用
#if !defined( _TEXTURE_ORIGIN_LOWER_LEFT ) && !defined( _TEXTURE_ORIGIN_UPPER_LEFT )    // カスタム指定が無い場合は NVN の標準に合わせる
#define _TEXTURE_ORIGIN_LOWER_LEFT              1   // テクスチャ原点は左下
#endif
#if !defined( _DEPTH_MODE_NEAR_IS_MINUS_W ) && !defined( _DEPTH_MODE_NEAR_IS_ZERO )     // カスタム指定が無い場合は NVN の標準に合わせる
#define _DEPTH_MODE_NEAR_IS_MINUS_W             1   // デプス範囲は -1 ～ 1
#endif
#define _MACRO_BRANCH_8KEY_ANIME                1   // 8キーアニメをマクロ分岐させる
#define _LIMIT_USER_ATTRIBUTE                   1   // アトリビュート数に余裕がある場合のみ法線/接線が利用できる

#define EFT_LOCATION_LAYOUT(x)
#define EFT_BINDING(x)

//------------------------------------------------------------------------------
// システム向け 定数バッファ
//------------------------------------------------------------------------------
// 後ろから順番に binding の index を割り振っていく
#define UNIFORM_BLOCK_LAYOUT_VIEW               5   // ビュー             定数バッファ (システム予約)
#define UNIFORM_BLOCK_LAYOUT_EMITTER_STATIC     6   // エミッタ固定       定数バッファ (システム予約)
#define UNIFORM_BLOCK_LAYOUT_EMITTER_DYNAMIC    7   // エミッタ動的       定数バッファ (システム予約)
#define UNIFORM_BLOCK_LAYOUT_EMITTER_FIELD      8   // エミッタフィールド 定数バッファ (システム予約)
#define UNIFORM_BLOCK_LAYOUT_EMITTER_PLUGIN     9   // エミッタプラグイン 定数バッファ (システム予約)
#define UNIFORM_BLOCK_LAYOUT_RESERVED_PARAM     10  // カスタムシェーダ   定数バッファ (システム予約)
#define SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_0    11  // カスタムシェーダ   定数バッファID 0 (ユーザー用)
#define SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_1    12  // カスタムシェーダ   定数バッファID 1 (ユーザー用)
#define SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_2    13  // カスタムシェーダ   定数バッファID 2 (ユーザー用)
#define SYS_CUSTOM_SHADER_UNIFORM_BLOCK_ID_3    14  // カスタムシェーダ   定数バッファID 3 (ユーザー用)
