﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_ParticleDeclaration.vsh

  Copyright (C)2011-2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

//------------------------------------------------------------------------------
// 定義
//------------------------------------------------------------------------------
// 頂点シェーダであることの定義
#define VERTEX_SHADER

// スフィアマップを処理するか
#if defined( _TEX_0_SPHERE_MAP ) || defined( _TEX_1_SPHERE_MAP ) || defined( _TEX_2_SPHERE_MAP )
#define _USE_SPHERE_MAP
#endif

// ストライプを使用するか
#if defined( _STRIPE_BILLBOARD ) || defined( _STRIPE_EMITTER_MATRIX ) || defined( _STRIPE_EMITTER_UPDOWN ) || defined( _STRIPE_RIBBON )
#define _USE_STRIPE
#endif

// スケールアニメーションを処理するか
#if defined( _SCALE_ANIM_1_KEY ) || defined( _SCALE_ANIM_2_KEY ) || defined( _SCALE_ANIM_3_KEY ) || defined( _SCALE_ANIM_4_KEY ) || defined( _SCALE_ANIM_5_KEY ) || defined( _SCALE_ANIM_6_KEY ) || defined( _SCALE_ANIM_7_KEY ) || defined( _SCALE_ANIM_8_KEY )
#define _SCALE_ANIM
#endif
// カラー0アニメーションを処理するか
#if defined( _COLOR_0_ANIM_1_KEY ) || defined( _COLOR_0_ANIM_2_KEY ) || defined( _COLOR_0_ANIM_3_KEY ) || defined( _COLOR_0_ANIM_4_KEY ) || defined( _COLOR_0_ANIM_5_KEY ) || defined( _COLOR_0_ANIM_6_KEY ) || defined( _COLOR_0_ANIM_7_KEY ) || defined( _COLOR_0_ANIM_8_KEY )
#define _COLOR_0_ANIM
#endif
// カラー1アニメーションを処理するか
#if defined( _COLOR_1_ANIM_1_KEY ) || defined( _COLOR_1_ANIM_2_KEY ) || defined( _COLOR_1_ANIM_3_KEY ) || defined( _COLOR_1_ANIM_4_KEY ) || defined( _COLOR_1_ANIM_5_KEY ) || defined( _COLOR_1_ANIM_6_KEY ) || defined( _COLOR_1_ANIM_7_KEY ) || defined( _COLOR_1_ANIM_8_KEY )
#define _COLOR_1_ANIM
#endif
// アルファ0アニメーションを処理するか
#if defined( _ALPHA_0_ANIM_1_KEY ) || defined( _ALPHA_0_ANIM_2_KEY ) || defined( _ALPHA_0_ANIM_3_KEY ) || defined( _ALPHA_0_ANIM_4_KEY ) || defined( _ALPHA_0_ANIM_5_KEY ) || defined( _ALPHA_0_ANIM_6_KEY ) || defined( _ALPHA_0_ANIM_7_KEY ) || defined( _ALPHA_0_ANIM_8_KEY )
#define _ALPHA_0_ANIM
#endif
// アルファ1アニメーションを処理するか
#if defined( _ALPHA_1_ANIM_1_KEY ) || defined( _ALPHA_1_ANIM_2_KEY ) || defined( _ALPHA_1_ANIM_3_KEY ) || defined( _ALPHA_1_ANIM_4_KEY ) || defined( _ALPHA_1_ANIM_5_KEY ) || defined( _ALPHA_1_ANIM_6_KEY ) || defined( _ALPHA_1_ANIM_7_KEY ) || defined( _ALPHA_1_ANIM_8_KEY )
#define _ALPHA_1_ANIM
#endif




//------------------------------------------------------------------------------
// VFXモード時は、以下の記述が必要
//------------------------------------------------------------------------------
#ifdef _USE_NN_VFX
out gl_PerVertex
{
    vec4 gl_Position;
};
#endif


#ifdef _USE_NN_VFX
//------------------------------------------------------------------------------
// エミッタプラグイン
//------------------------------------------------------------------------------
EFT_LOCATION_LAYOUT(0) in vec4     sysEmitterPluginAttr0;                   // エミッタプラグイン用入力アトリビュート0
EFT_LOCATION_LAYOUT(1) in vec4     sysEmitterPluginAttr1;                   // エミッタプラグイン用入力アトリビュート1
EFT_LOCATION_LAYOUT(2) in vec4     sysEmitterPluginAttr2;                   // エミッタプラグイン用入力アトリビュート2
EFT_LOCATION_LAYOUT(3) in vec4     sysEmitterPluginAttr3;                   // エミッタプラグイン用入力アトリビュート3
EFT_LOCATION_LAYOUT(4) in vec4     sysEmitterPluginAttr4;                   // エミッタプラグイン用入力アトリビュート4
#endif


#ifdef _USE_NN_VFX

//------------------------------------------------------------------------------
// 入力
//------------------------------------------------------------------------------
#ifdef _PRIMITIVE
EFT_LOCATION_LAYOUT(5) in vec4  sysPosAttr;                                // 入力頂点 ( -0.5, 0.5 ) -> ( 0.5, -0.5 )
#else
vec4  sysPosAttr;                                   // 入力頂点 ( -0.5, 0.5 ) -> ( 0.5, -0.5 ) パーティクル時は、gl_VertexID から生成
#endif

#ifdef _USE_TEXCOORD_ATTR
EFT_LOCATION_LAYOUT(6) in vec4  sysTexCoordAttr;                           // 入力テクスチャ座標  (プリミティブ利用時)
#endif
#ifdef _USE_NORMAL_ATTR
EFT_LOCATION_LAYOUT(7) in vec3  sysNormalAttr;                             // 入力法線            (プリミティブ利用時)
#endif
#ifdef _USE_TANGENT_ATTR
EFT_LOCATION_LAYOUT(8) in vec4  sysTangentAttr;                            // 入力接線            (プリミティブ利用時)
#endif
#ifdef _USE_COLOR0_ATTR
EFT_LOCATION_LAYOUT(9) in vec4  sysVertexColor0Attr;                       // 入力カラー0         (プリミティブ/ストライプ利用時)
#endif
#ifdef _USE_COLOR1_ATTR
EFT_LOCATION_LAYOUT(10) in vec4  sysVertexColor1Attr;                       // 入力カラー1         (プリミティブ/ストライプ利用時)
#endif

EFT_LOCATION_LAYOUT(11) in vec4  sysLocalPosAttr;                           // ローカル座標 / パーティクル寿命
EFT_LOCATION_LAYOUT(12) in vec4  sysLocalVecAttr;                           // ローカルベクトル / エミッタ放出時タイム

#if defined( _PARTICLE_TYPE_VEL_LOOK ) || defined( _PARTICLE_TYPE_VEL_LOOK_POLYGON ) || defined( _PARTICLE_TYPE_WITH_SCALE_Z_DIRECTIONAL ) || defined( _VELOCITY_SCALE_Y )
#define _USE_LOCAL_DIFF_ATTR
EFT_LOCATION_LAYOUT(13) in vec4  sysLocalDiffAttr;                          // ローカル位置差分 / 空き
#endif

EFT_LOCATION_LAYOUT(14) in vec4  sysScaleAttr;                              // パーティクルスケール /
EFT_LOCATION_LAYOUT(15) in vec4  sysRandomAttr;                             // パーティクル固有ランダム

#ifdef _USE_ROTATE
EFT_LOCATION_LAYOUT(16) in vec4  sysInitRotateAttr;                         // パーティクル初期回転
#endif

#if defined( _COLOR0_INHERIT ) || defined( _ALPHA0_INHERIT )
EFT_LOCATION_LAYOUT(17) in vec4  sysColor0Attr;                             // パーティクル初期カラー0
#endif
#if defined( _COLOR1_INHERIT ) || defined( _ALPHA1_INHERIT )
EFT_LOCATION_LAYOUT(18) in vec4  sysColor1Attr;                             // パーティクル初期カラー1
#endif

#ifndef _EMITTER_FOLLOW_TYPE_ALL
EFT_LOCATION_LAYOUT(19) in vec4  sysEmtMat0Attr;                            // エミッタマトリクス0
EFT_LOCATION_LAYOUT(20) in vec4  sysEmtMat1Attr;                            // エミッタマトリクス1
EFT_LOCATION_LAYOUT(21) in vec4  sysEmtMat2Attr;                            // エミッタマトリクス2
#endif

#ifdef _CALC_TYPE_GPU_SO
EFT_LOCATION_LAYOUT(22) in  vec4    sysInPos;                               // ストリームアウト入力 位置
EFT_LOCATION_LAYOUT(23) in  vec4    sysInVec;                               // ストリームアウト入力 速度
#endif

int      sysIndexAttr;                              // 入力インデックス ( 0, 1, 2, 3 ) / sysPosAttr.w から取得


//------------------------------------------------------------------------------
// 出力
//------------------------------------------------------------------------------
EFT_LOCATION_LAYOUT(0) out vec4    sysColor0Vary;                      // カラー0
EFT_LOCATION_LAYOUT(1) out vec4    sysColor1Vary;                      // カラー1
EFT_LOCATION_LAYOUT(2) out vec4    sysTexCoord01Vary;                  // テクスチャ座標0-1
EFT_LOCATION_LAYOUT(3) out vec2    sysTexCoord2Vary;                   // テクスチャ座標2
EFT_LOCATION_LAYOUT(4) out vec4    sysFragCoordVary;                   // スクリーン座標参照用
EFT_LOCATION_LAYOUT(5) out vec4    sysFragParamVary;                   // 各種パラメータ( MasterAlpha, CombinerAnime0.x, empty, empty )
EFT_LOCATION_LAYOUT(6) out vec4    sysFragParamVary2;                  // 各種パラメータ( LifeRatio2, CombinerAnime0.y, CombinerAnime0.z, empty )
EFT_LOCATION_LAYOUT(7) out vec4    sysPrimitiveColorVary;              // プリミティブカラー
EFT_LOCATION_LAYOUT(8) out vec3    sysWorldPositionVary;               // ワールド座標
EFT_LOCATION_LAYOUT(9) out vec3    sysWorldNormalVary;                 // ワールド法線
EFT_LOCATION_LAYOUT(10) out vec3    sysWorldTangentVary;                // ワールド接線
EFT_LOCATION_LAYOUT(11) out vec3    sysWorldBinormalVary;               // ワールド従法線
EFT_LOCATION_LAYOUT(12) out vec3    sysEyeVecVary;                      // 視線ベクトル
EFT_LOCATION_LAYOUT(13) out vec4    sysFragRandomVary;                  // 粒の持つ乱数値

EFT_LOCATION_LAYOUT(14) out vec4    sysOutPos;                                                  // ストリームアウト位置( ストリームアウトシェーダ内でしか利用できない )
EFT_LOCATION_LAYOUT(15) out vec4    sysOutVec;                                                  // ストリームアウト速度( ストリームアウトシェーダ内でしか利用できない )

#else

out vec4    sysOutPos;                                                  // ストリームアウト位置( ストリームアウトシェーダ内でしか利用できない )
out vec4    sysOutVec;                                                  // ストリームアウト速度( ストリームアウトシェーダ内でしか利用できない )


#ifdef _PRIMITIVE
    #define _USE_NORMAL_ATTR
    #define _USE_TANGENT_ATTR
    #define _USE_COLOR0_ATTR
#endif

// Windows版 のみ: アトリビュート数に余裕がある場合のみ法線/接線が利用できる。
#if defined( _LIMIT_USER_ATTRIBUTE )
#if defined( _ALPHA0_INHERIT ) || defined( _ALPHA1_INHERIT ) || defined( _COLOR0_INHERIT ) || defined( _COLOR1_INHERIT ) || defined( _EMITTER_FOLLOW_TYPE_NONE ) || defined( _EMITTER_FOLLOW_TYPE_POS )
    #undef _USE_NORMAL_ATTR
    #undef _USE_TANGENT_ATTR
#endif
#endif


//------------------------------------------------------------------------------
// 入力
//------------------------------------------------------------------------------
// 頂点単位
in vec4  sysPosAttr;                    // 入力頂点 ( -0.5, 0.5 ) -> ( 0.5, -0.5 )
in vec4  sysTexCoordAttr;               // 入力テクスチャ座標 (プリミティブ利用時)
in vec3  sysNormalAttr;                 // 入力法線           (プリミティブ利用時)
in vec4  sysTangentAttr;                // 入力接線           (プリミティブ利用時)
in vec4  sysVertexColor0Attr;           // 入力カラー         (プリミティブ/ストライプ利用時)
in vec4  sysVertexColor1Attr;           // 入力カラー         (プリミティブ/ストライプ利用時)
int      sysIndexAttr;                  // 入力インデックス ( 0, 1, 2, 3 ) / sysPosAttr.w から取得
in vec4  sysLocalPosAttr;               // パーティクル1枚単位:ローカル座標 / パーティクル寿命
in vec4  sysLocalVecAttr;               // パーティクル1枚単位:ローカルベクトル / エミッタ放出時タイム
in vec4  sysLocalDiffAttr;              // パーティクル1枚単位:ローカル位置差分 / 空き
#define _USE_LOCAL_DIFF_ATTR
in vec4  sysScaleAttr;                  // パーティクル1枚単位:スケール /
in vec4  sysRandomAttr;                 // パーティクル1枚単位:ランダム
in vec4  sysInitRotateAttr;             // パーティクル1枚単位:初期回転
in vec4  sysEmtMat0Attr;                // パーティクル1枚単位:エミッタマトリクス0
in vec4  sysEmtMat1Attr;                // パーティクル1枚単位:エミッタマトリクス1
in vec4  sysEmtMat2Attr;                // パーティクル1枚単位:エミッタマトリクス2
in vec4  sysEmtRTMat0Attr;              // パーティクル1枚単位:エミッタRTマトリクス0
in vec4  sysEmtRTMat1Attr;              // パーティクル1枚単位:エミッタRTマトリクス1
in vec4  sysEmtRTMat2Attr;              // パーティクル1枚単位:エミッタRTマトリクス2
in vec4  sysColor0Attr;                 // パーティクル1枚単位:初期カラー0
in vec4  sysColor1Attr;                 // パーティクル1枚単位:初期カラー1

in vec4  sysEmitterPluginAttr0;         // エミッタプラグイン用入力アトリビュート0
in vec4  sysEmitterPluginAttr1;         // エミッタプラグイン用入力アトリビュート1
in vec4  sysEmitterPluginAttr2;         // エミッタプラグイン用入力アトリビュート2
in vec4  sysEmitterPluginAttr3;         // エミッタプラグイン用入力アトリビュート3
in vec4  sysEmitterPluginAttr4;         // エミッタプラグイン用入力アトリビュート4

#ifdef _CALC_TYPE_GPU_SO
in  vec4    sysInPos;                   // ストリームアウト入力 位置
in  vec4    sysInVec;                   // ストリームアウト入力 速度
#endif


//------------------------------------------------------------------------------
// 出力
//------------------------------------------------------------------------------
out vec4    sysColor0Vary;                      // カラー0
out vec4    sysColor1Vary;                      // カラー1
out vec4    sysTexCoord01Vary;                  // テクスチャ座標0-1
out vec2    sysTexCoord2Vary;                   // テクスチャ座標2
out vec4    sysFragCoordVary;                   // スクリーン座標参照用
out vec4    sysFragParamVary;                   // 各種パラメータ( MasterAlpha, CombinerAnime0.x, empty, empty )
out vec4    sysFragParamVary2;                  // 各種パラメータ( LifeRatio2, CombinerAnime0.y, CombinerAnime0.z, empty )
out vec4    sysPrimitiveColorVary;              // プリミティブカラー
out vec3    sysWorldPositionVary;               // ワールド座標
out vec3    sysWorldNormalVary;                 // ワールド法線
out vec3    sysWorldTangentVary;                // ワールド接線
out vec3    sysWorldBinormalVary;               // ワールド従法線
out vec3    sysEyeVecVary;                      // 視線ベクトル
out vec4    sysFragRandomVary;                  // 粒の持つ乱数値

#endif

#define sysMasterAlpha      sysFragParamVary.x      // マスターアルファ
#define sysShaderAnim       sysFragParamVary.y      // シェーダアニメーションX
#define sysShaderAnimY      sysFragParamVary2.y     // シェーダアニメーションY
#define sysShaderAnimZ      sysFragParamVary2.z     // シェーダアニメーションZ
#define sysLifeRatio        sysFragParamVary2.x     // 現在の寿命の割合(0.0-1.0)
#define sysParticleRandom   sysFragRandomVary       // 粒の持つ乱数値

//------------------------------------------------------------------------------
// エミッタRTマトリクス MakesysEmitterRTMatrixで生成されます。
//------------------------------------------------------------------------------
vec4 sysEmitterRT[3];   // 追従設定により決定された Emitter のRTマトリクス。


//------------------------------------------------------------------------------
// パーティクル情報
//------------------------------------------------------------------------------
float   sysPtclTime;                                        // パーティクル タイム
float   sysPtclAlphaRate;                                   // パーティクル アルファ係数
vec3    sysPtclScale;                                       // パーティクルスケール
vec3    sysPtclLocalPos;                                    // パーティクルローカル座標
vec3    sysPtclLocalVec;                                    // パーティクルローカル速度
vec3    sysPtclWorldPos;                                    // パーティクル世界座標
vec3    sysPtclWorldPosDelta;                               // パーティクル移動差分
mat4    sysPtclRotateMatrix;                                // パーティクル回転行列
vec4    sysPtclFragCoordCenter;                             // スクリーン座標での位置
float   sysPtclVertexDepthValue;                            // 頂点のデプス値
float   sysPtclVertexDepthValueCenter;                      // 頂点のデプス値（パーティクルの中心）
float   sysPtclTextureDepthValue;                           // テクスチャのデプス値
#define sysPtclRandomX         sysRandomAttr.x              // パーティクル 固有ランダムX
#define sysPtclRandomY         sysRandomAttr.y              // パーティクル 固有ランダムY
#define sysPtclRandomZ         sysRandomAttr.z              // パーティクル 固有ランダムZ
#define sysPtclRandomW         sysRandomAttr.w              // パーティクル 固有ランダムW

//#ifdef _CALC_TYPE_GPU_TIME
#define sysPtclEmitTime        sysLocalVecAttr.w            // パーティクル 放出エミッタ時間
#define sysPtclLife            int( sysLocalPosAttr.w )     // パーティクル 寿命


//------------------------------------------------------------------------------
// テクスチャ座標変換行列
//------------------------------------------------------------------------------
#ifdef _TEXTURE_ORIGIN_LOWER_LEFT
#ifdef _DEPTH_MODE_NEAR_IS_MINUS_W
    mat4 sysTexCoordTransformMatrix =
        mat4( 0.5,  0.0,  0.0,  0.0,
              0.0,  0.5,  0.0,  0.0,
              0.0,  0.0,  0.5,  0.0,
              0.5,  0.5,  0.5,  1.0 );
#endif
#ifdef _DEPTH_MODE_NEAR_IS_ZERO
    mat4 sysTexCoordTransformMatrix =
        mat4( 0.5,  0.0,  0.0,  0.0,
              0.0,  0.5,  0.0,  0.0,
              0.0,  0.0,  1.0,  0.0,
              0.5,  0.5,  0.0,  1.0 );
#endif
#endif

#ifdef _TEXTURE_ORIGIN_UPPER_LEFT
#ifdef _DEPTH_MODE_NEAR_IS_MINUS_W
    mat4 sysTexCoordTransformMatrix =
        mat4( 0.5,  0.0,  0.0,  0.0,
              0.0, -0.5,  0.0,  0.0,
              0.0,  0.0,  0.5,  0.0,
              0.5,  0.5,  0.5,  1.0 );
#endif
#ifdef _DEPTH_MODE_NEAR_IS_ZERO
    mat4 sysTexCoordTransformMatrix =
        mat4( 0.5,  0.0,  0.0,  0.0,
              0.0, -0.5,  0.0,  0.0,
              0.0,  0.0,  1.0,  0.0,
              0.5,  0.5,  0.0,  1.0 );
#endif
#endif


//------------------------------------------------------------------------------
// 互換性保持
//------------------------------------------------------------------------------
// 頂点単位
#define v_inPos             sysPosAttr
#define v_inIndex           sysIndexAttr
#define v_inTexCoord        sysTexCoordAttr
#define v_inNormal          sysNormalAttr
#define v_inColor           sysVertexColor0Attr
//#define v_inTexCoord1

// パーティクル単位
#define v_inWldPos          sysPtclWorldPos
#define v_inScl             sysScaleAttr
//#define v_inWldPosDf
#define v_inColor0          sysColor0Attr
#define v_inColor1          sysColor1Attr
#define v_inEmtMat0         sysEmtMat0Attr
#define v_inEmtMat1         sysEmtMat1Attr
#define v_inEmtMat2         sysEmtMat2Attr
#define v_inRandom          sysRandomAttr
#define v_inVec             sysLocalVecAttr
#define inScaleX            v_inScl.x
#define inScaleY            v_inScl.y
#define inWorldPos          v_inWldPos.xyz
#define inLocalPos          v_inWldPos.xyz
//#define inWorldPosDf      v_inWldPosDf.xyz
#define inColor0            v_inColor0
#define inColor1            v_inColor1
//#define inRotate          v_inRot.xyz
//#define inIniVec          v_inVec.xyz
//#define inDynamicsRand    v_inVec.w
#define ptclRandomX         v_inRandom.x
#define ptclRandomY         v_inRandom.y
#define ptclRandomZ         v_inRandom.z
//#define ptclLife          v_inRandom.w


// ピクセルシェーダに渡す値
//#define v_outPos
#define v_outWorldPosition  sysWorldPositionVary
#define v_outWorldNormal    sysWorldNormalVary
#define v_outWorldTangent   sysWorldTangentVary
#define v_outWorldBinormal  sysWorldBinormalVary
#define g_worldNormal       v_outWorldNormal
#define g_worldTangent      v_outWorldTangent
#define g_worldBinormal     v_outWorldBinormal
#define g_worldVertexPos    v_outWorldPosition

#define v_outColor0         sysColor0Vary
#define v_outColor1         sysColor1Vary
#define v_outPrimitiveColor sysWorldPrimitiveColorVary
#define v_outTexCoord       sysTexCoord01Vary
#define v_outTexCoord0      v_outTexCoord.xy
#define v_outTexCoord1      v_outTexCoord.zw
#define v_outTexCoord2      sysTexCoord2Vary
#define v_outEyeVec         sysEyeVecVary
//#define v_outDepthTexCoordProj
//#define v_outFrameTexCoordProj
//#define v_outSphereTexCoord
//#define v_outProjectionTexSRT0CoordProj
//#define v_outProjectionTexSRT1CoordProj
//#define v_outTexSurfaceAnim

//------------------------------------------------------------------------------
//  アニメーション関係のエイリアス定義
//------------------------------------------------------------------------------
#define color0AnimKeyNum        animKeyNum0.x   // カラー0アニメーションキー数
#define alpha0AnimKeyNum        animKeyNum0.y   // アルファ0アニメーションキー数
#define color1AnimKeyNum        animKeyNum0.z   // カラー1アニメーションキー数
#define alpha1AnimKeyNum        animKeyNum0.w   // アルファ1アニメーションキー数
#define scaleAnimKeyNum         animKeyNum1.x   // スケールアニメーションキー数
#define shaderAnimKeyNum        animKeyNum1.y   // シェーダ係数アニメーションキー数

#define color0LoopRate          animLoopParam0.x
#define alpha0LoopRate          animLoopParam0.y
#define color1LoopRate          animLoopParam0.z
#define alpha1LoopRate          animLoopParam0.w
#define scaleLoopRate           animLoopParam1.x
#define color0IsLoopInitRandom  animLoopParam1.y
#define alpha0IsLoopInitRandom  animLoopParam1.z
#define color1IsLoopInitRandom  animLoopParam1.w
#define alpha1IsLoopInitRandom  animLoopParam2.x
#define scaleIsLoopInitRandom   animLoopParam2.y


#ifdef CUSTOM_SHADER_NONE
#define USR_VERTEX_SETTING_NONE
#endif
#ifdef CUSTOM_SHADER_INDEX_1
#define USR_VERTEX_SETTING_1
#endif
#ifdef CUSTOM_SHADER_INDEX_2
#define USR_VERTEX_SETTING_2
#endif
#ifdef CUSTOM_SHADER_INDEX_3
#define USR_VERTEX_SETTING_3
#endif
#ifdef CUSTOM_SHADER_INDEX_4
#define USR_VERTEX_SETTING_4
#endif
#ifdef CUSTOM_SHADER_INDEX_5
#define USR_VERTEX_SETTING_5
#endif
#ifdef CUSTOM_SHADER_INDEX_6
#define USR_VERTEX_SETTING_6
#endif
#ifdef CUSTOM_SHADER_INDEX_7
#define USR_VERTEX_SETTING_7
#endif
#ifdef CUSTOM_SHADER_INDEX_8
#define USR_VERTEX_SETTING_8
#endif
#ifdef CUSTOM_SHADER_FLAG_0
#define USR_VERTEX_FLAG_0
#endif
#ifdef CUSTOM_SHADER_FLAG_1
#define USR_VERTEX_FLAG_1
#endif
#ifdef CUSTOM_SHADER_FLAG_2
#define USR_VERTEX_FLAG_2
#endif
#ifdef CUSTOM_SHADER_FLAG_3
#define USR_VERTEX_FLAG_3
#endif
#ifdef CUSTOM_SHADER_FLAG_4
#define USR_VERTEX_FLAG_4
#endif
#ifdef CUSTOM_SHADER_FLAG_5
#define USR_VERTEX_FLAG_5
#endif
#ifdef CUSTOM_SHADER_FLAG_6
#define USR_VERTEX_FLAG_6
#endif
#ifdef CUSTOM_SHADER_FLAG_7
#define USR_VERTEX_FLAG_7
#endif
#ifdef CUSTOM_SHADER_FLAG_8
#define USR_VERTEX_FLAG_8
#endif
#ifdef CUSTOM_SHADER_FLAG_9
#define USR_VERTEX_FLAG_9
#endif
#ifdef CUSTOM_SHADER_FLAG_10
#define USR_VERTEX_FLAG_10
#endif
#ifdef CUSTOM_SHADER_FLAG_11
#define USR_VERTEX_FLAG_11
#endif
#ifdef CUSTOM_SHADER_FLAG_12
#define USR_VERTEX_FLAG_12
#endif
#ifdef CUSTOM_SHADER_FLAG_13
#define USR_VERTEX_FLAG_13
#endif
#ifdef CUSTOM_SHADER_FLAG_14
#define USR_VERTEX_FLAG_14
#endif
#ifdef CUSTOM_SHADER_FLAG_15
#define USR_VERTEX_FLAG_15
#endif
#ifdef CUSTOM_SHADER_FLAG_16
#define USR_VERTEX_FLAG_16
#endif
#ifdef CUSTOM_SHADER_FLAG_17
#define USR_VERTEX_FLAG_17
#endif
#ifdef CUSTOM_SHADER_FLAG_18
#define USR_VERTEX_FLAG_18
#endif
#ifdef CUSTOM_SHADER_FLAG_19
#define USR_VERTEX_FLAG_19
#endif
#ifdef CUSTOM_SHADER_FLAG_20
#define USR_VERTEX_FLAG_20
#endif
#ifdef CUSTOM_SHADER_FLAG_21
#define USR_VERTEX_FLAG_21
#endif
#ifdef CUSTOM_SHADER_FLAG_22
#define USR_VERTEX_FLAG_22
#endif
#ifdef CUSTOM_SHADER_FLAG_23
#define USR_VERTEX_FLAG_23
#endif
#ifdef CUSTOM_SHADER_FLAG_24
#define USR_VERTEX_FLAG_24
#endif
#ifdef CUSTOM_SHADER_FLAG_25
#define USR_VERTEX_FLAG_25
#endif
#ifdef CUSTOM_SHADER_FLAG_26
#define USR_VERTEX_FLAG_26
#endif
#ifdef CUSTOM_SHADER_FLAG_27
#define USR_VERTEX_FLAG_27
#endif
#ifdef CUSTOM_SHADER_FLAG_28
#define USR_VERTEX_FLAG_28
#endif
#ifdef CUSTOM_SHADER_FLAG_29
#define USR_VERTEX_FLAG_29
#endif
#ifdef CUSTOM_SHADER_FLAG_30
#define USR_VERTEX_FLAG_30
#endif
#ifdef CUSTOM_SHADER_FLAG_31
#define USR_VERTEX_FLAG_31
#endif


//---------------------------------------------------
// 関数前方宣言
//---------------------------------------------------
void AdjustmentWorldPosition();                         // カスタムシェーダ: 頂点位置補正
void FinalAdjustmentVertexProcess();                    // カスタムシェーダ: 最終位置補正
void EP_AdjustmentWorldPosition();                      // エミッタプラグイン: 頂点位置補正
void EP_FinalAdjustmentVertexProcess();                 // エミッタプラグイン: 最終位置補正
float GetDepthValueFromTexture( vec4 projection );      // デプステクスチャから深度値を取得
float GetDepthValue( vec4 position );                   // 現在のデプス値を取得


//------------------------------------------------------------------------------
// この頂点を棄却します
//------------------------------------------------------------------------------
void DiscardVertex()
{
    // カメラから見えない点に飛ばしてカリングさせる。
    // ピクセルシェーダに入れないのが目的。
    gl_Position.z = sysScreenFar * 5.0;
    gl_Position.x = gl_Position.y = 0.0;
    sysMasterAlpha = 0.0;
}

//---------------------------------------------------
// エミッタRTマトリクスを生成します。
// 生成されたマトリクスは、sysEmitterRT[3]に出力されます。
//---------------------------------------------------
void MakeEmitterRTMatrix()
{
#if defined( _CALC_TYPE_CPU ) && defined( _USE_NW_EFT )
    // CPUの場合

#ifdef _EMITTER_FOLLOW_TYPE_ALL
    // 完全追従
    sysEmitterRT[ 0 ] = sysEmitterRTMatrix[ 0 ];
    sysEmitterRT[ 1 ] = sysEmitterRTMatrix[ 1 ];
    sysEmitterRT[ 2 ] = sysEmitterRTMatrix[ 2 ];
#endif

#ifdef _EMITTER_FOLLOW_TYPE_POS
    // 位置のみ追従
    sysEmitterRT[ 0 ] = vec4( sysEmtRTMat0Attr.xyz, sysEmitterMatrix[ 0 ].w );
    sysEmitterRT[ 1 ] = vec4( sysEmtRTMat1Attr.xyz, sysEmitterMatrix[ 1 ].w );
    sysEmitterRT[ 2 ] = vec4( sysEmtRTMat2Attr.xyz, sysEmitterMatrix[ 2 ].w );
#endif

#ifdef _EMITTER_FOLLOW_TYPE_NONE
    // 追従なし
    sysEmitterRT[ 0 ] = sysEmtRTMat0Attr;
    sysEmitterRT[ 1 ] = sysEmtRTMat1Attr;
    sysEmitterRT[ 2 ] = sysEmtRTMat2Attr;
#endif

#else

    // eft2：CPUエミッタ時は、sysEmtRTMat0Attrを利用して生成、GPU,+SO時は、sysEmtMat2Attr を利用して生成
    // vfx ：sysEmtMat2Attr を利用して生成。sysEmtRTMat0Attrは入力されない

#ifdef _EMITTER_FOLLOW_TYPE_ALL
    // 完全追従の場合、エミッタのSRTを使用

    vec3 basisX = sysEmitterRTMatrix[ 0 ].xyz;
    vec3 basisY = sysEmitterRTMatrix[ 1 ].xyz;
    vec3 basisZ = sysEmitterRTMatrix[ 2 ].xyz;

    float emScaleX = length( basisX );
    float emScaleY = length( basisY );
    float emScaleZ = length( basisZ );

    if ( emScaleX > 0.0 )
    {
        float inv = 1.0 / emScaleX;
        sysEmitterRT[ 0 ].x = sysEmitterRTMatrix[ 0 ].x * inv;
        sysEmitterRT[ 1 ].x = sysEmitterRTMatrix[ 1 ].x * inv;
        sysEmitterRT[ 2 ].x = sysEmitterRTMatrix[ 2 ].x * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].x = sysEmitterRT[ 1 ].x = sysEmitterRT[ 2 ].x = 0.0;
    }

    if ( emScaleY > 0.0 )
    {
        float inv = 1.0 / emScaleY;
        sysEmitterRT[ 0 ].y = sysEmitterRTMatrix[ 0 ].y * inv;
        sysEmitterRT[ 1 ].y = sysEmitterRTMatrix[ 1 ].y * inv;
        sysEmitterRT[ 2 ].y = sysEmitterRTMatrix[ 2 ].y * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].y = sysEmitterRT[ 1 ].y = sysEmitterRT[ 2 ].y = 0.0;
    }

    if ( emScaleZ > 0.0 )
    {
        float inv = 1.0 / emScaleZ;
        sysEmitterRT[ 0 ].z = sysEmitterRTMatrix[ 0 ].z * inv;
        sysEmitterRT[ 1 ].z = sysEmitterRTMatrix[ 1 ].z * inv;
        sysEmitterRT[ 2 ].z = sysEmitterRTMatrix[ 2 ].z * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].z = sysEmitterRT[ 1 ].z = sysEmitterRT[ 2 ].z = 0.0;
    }

    sysEmitterRT[ 0 ].w = sysEmitterRTMatrix[ 0 ].w;
    sysEmitterRT[ 1 ].w = sysEmitterRTMatrix[ 1 ].w;
    sysEmitterRT[ 2 ].w = sysEmitterRTMatrix[ 2 ].w;

#else

    // それ以外の場合、パーティクルごとのSRTを使用

    vec3 basisX = vec3( sysEmtMat0Attr.x, sysEmtMat1Attr.x, sysEmtMat2Attr.x );
    vec3 basisY = vec3( sysEmtMat0Attr.y, sysEmtMat1Attr.y, sysEmtMat2Attr.y );
    vec3 basisZ = vec3( sysEmtMat0Attr.z, sysEmtMat1Attr.z, sysEmtMat2Attr.z );

    float emScaleX = length( basisX );
    float emScaleY = length( basisY );
    float emScaleZ = length( basisZ );

    if ( emScaleX > 0.0 )
    {
        float inv = 1.0 / emScaleX;
        sysEmitterRT[ 0 ].x = sysEmtMat0Attr.x * inv;
        sysEmitterRT[ 1 ].x = sysEmtMat1Attr.x * inv;
        sysEmitterRT[ 2 ].x = sysEmtMat2Attr.x * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].x = sysEmitterRT[ 1 ].x = sysEmitterRT[ 2 ].x = 0.0;
    }

    if ( emScaleY > 0.0 )
    {
        float inv = 1.0 / emScaleY;
        sysEmitterRT[ 0 ].y = sysEmtMat0Attr.y * inv;
        sysEmitterRT[ 1 ].y = sysEmtMat1Attr.y * inv;
        sysEmitterRT[ 2 ].y = sysEmtMat2Attr.y * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].y = sysEmitterRT[ 1 ].y = sysEmitterRT[ 2 ].y = 0.0;
    }

    if ( emScaleZ > 0.0 )
    {
        float inv = 1.0 / emScaleZ;
        sysEmitterRT[ 0 ].z = sysEmtMat0Attr.z * inv;
        sysEmitterRT[ 1 ].z = sysEmtMat1Attr.z * inv;
        sysEmitterRT[ 2 ].z = sysEmtMat2Attr.z * inv;
    }
    else
    {
        sysEmitterRT[ 0 ].z = sysEmitterRT[ 1 ].z = sysEmitterRT[ 2 ].z = 0.0;
    }

    sysEmitterRT[ 0 ].w = sysEmtMat0Attr.w;
    sysEmitterRT[ 1 ].w = sysEmtMat1Attr.w;
    sysEmitterRT[ 2 ].w = sysEmtMat2Attr.w;

#endif

#endif
}

//---------------------------------------------------
// 引数vにエミッタRTマトリクスを適用します。
//---------------------------------------------------
vec3 ApplyEmitterRotateMatrix( vec3 v )
{
    vec4 ret;
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    mat4    tempMat;
    tempMat[0] = vec4( sysEmitterMatrix[0].xyz, 0.0 );
    tempMat[1] = vec4( sysEmitterMatrix[1].xyz, 0.0 );
    tempMat[2] = vec4( sysEmitterMatrix[2].xyz, 0.0 );
    tempMat[3] = vec4( 0.0, 0.0, 0.0, 1.0 );
    ret = vec4( v, 1.0 ) * tempMat;
#else
    mat4    tempMat;
    tempMat[0] = vec4( sysEmitterRT[0].xyz, 0.0 );
    tempMat[1] = vec4( sysEmitterRT[1].xyz, 0.0 );
    tempMat[2] = vec4( sysEmitterRT[2].xyz, 0.0 );
    tempMat[3] = vec4( 0.0, 0.0, 0.0, 1.0 );
    ret = vec4( v, 1.0 ) * tempMat;
#endif

    return ret.xyz;
}

//---------------------------------------------------
// 引数vにエミッタRTマトリクスの逆行列を適用します。
//---------------------------------------------------
vec3 ApplyEmitterRotateInvMatrix( vec3 v )
{
    // 回転行列なので、転置をとれば逆行列になる。
    vec4 ret;
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    mat4    tempMat;
    tempMat[0] = vec4( sysEmitterMatrix[0].xyz, 0.0 );
    tempMat[1] = vec4( sysEmitterMatrix[1].xyz, 0.0 );
    tempMat[2] = vec4( sysEmitterMatrix[2].xyz, 0.0 );
    tempMat[3] = vec4( 0.0, 0.0, 0.0, 1.0 );
    ret = vec4( v, 1.0 ) * transpose(tempMat);
#else
    mat4    tempMat;
    tempMat[0] = vec4( sysEmitterRT[0].xyz, 0.0 );
    tempMat[1] = vec4( sysEmitterRT[1].xyz, 0.0 );
    tempMat[2] = vec4( sysEmitterRT[2].xyz, 0.0 );
    tempMat[3] = vec4( 0.0, 0.0, 0.0, 1.0 );
    ret = vec4( v, 1.0 ) * transpose(tempMat);
#endif
    return ret.xyz;
}



//------------------------------------------------------------------------------
// 追従設定によるエミッタマトリクス反映
//------------------------------------------------------------------------------
vec3 ApplyEmitterMatrix( vec3 v )
{
    vec3 ret;
    vec4 temp = vec4( v, 1.0 );
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    ret.x = dot( sysEmitterMatrix[0], temp );
    ret.y = dot( sysEmitterMatrix[1], temp );
    ret.z = dot( sysEmitterMatrix[2], temp );
#endif
#ifdef _EMITTER_FOLLOW_TYPE_POS
    vec4 m0 = vec4( sysEmtMat0Attr.xyz, sysEmitterMatrix[0].w );
    vec4 m1 = vec4( sysEmtMat1Attr.xyz, sysEmitterMatrix[1].w );
    vec4 m2 = vec4( sysEmtMat2Attr.xyz, sysEmitterMatrix[2].w );
    ret.x = dot( m0, temp );
    ret.y = dot( m1, temp );
    ret.z = dot( m2, temp );
#endif
#ifdef _EMITTER_FOLLOW_TYPE_NONE
    ret.x = dot( sysEmtMat0Attr, temp );
    ret.y = dot( sysEmtMat1Attr, temp );
    ret.z = dot( sysEmtMat2Attr, temp );
#endif

    return ret;
}


//---------------------------------------------------
// エミッタローカル位置を取得します。
//---------------------------------------------------
vec3 GetEmitterLocalPos()
{
    vec4 ret;
    ret.x = sysEmitterMatrix[0].w;
    ret.y = sysEmitterMatrix[1].w;
    ret.z = sysEmitterMatrix[2].w;
    ret.w = 1.0;
    return ( ret * inverse( sysEmitterMatrix ) ).xyz;
}


//------------------------------------------------------------------------------
// テクスチャ座標アニメーションの計算
//------------------------------------------------------------------------------
vec4 CalculateTextureShiftAnim( vec2 inUv, ResTexUvShiftAnim anim,
                               float time, int index, int randomMode, vec4 randomSeed )
{
    vec4 ret;

    #define uvScrollAddX        anim.pm0.x
    #define uvScrollAddY        anim.pm0.y
    #define uvScrollInitX       anim.pm0.z
    #define uvScrollInitY       anim.pm0.w
    #define uvScrollInitRandX   anim.pm1.x
    #define uvScrollInitRandY   anim.pm1.y
    #define uvScaleAddX         anim.pm1.z
    #define uvScaleAddY         anim.pm1.w
    #define uvScaleInitX        anim.pm2.x
    #define uvScaleInitY        anim.pm2.y
    #define uvScaleInitRandX    anim.pm2.z
    #define uvScaleInitRandY    anim.pm2.w
    #define uvScaleBaseX        anim.pm4.x
    #define uvScaleBaseY        anim.pm4.y
    #define uvDivX              anim.pm4.z
    #define uvDivY              anim.pm4.w

    float random0 = randomSeed.x;
    float random1 = randomSeed.y;
    float random2 = randomSeed.z;
    float random3 = randomSeed.x;
    float random4 = randomSeed.y;

    if ( randomMode == 1 )
    {
        random0 = randomSeed.y;
        random1 = randomSeed.z;
        random2 = randomSeed.x;
        random3 = randomSeed.y;
        random4 = randomSeed.z;
    }
    else if ( randomMode == 2 )
    {
        random0 = randomSeed.z;
        random1 = randomSeed.x;
        random2 = randomSeed.y;
        random3 = randomSeed.x;
        random4 = randomSeed.y;
    }

    // 分割数
    int divX = int( uvDivX );
    int divY = int( uvDivY );

    // 分割後の表示位置
    int indexX = index % divX;
    int indexY = index / divX;

    // UVスケール
    float uScale = uvScaleBaseX * (1/uvDivX);
    float vScale = uvScaleBaseY * (1/uvDivY);

    // 初期値
    float uvScrInitX  = uvScrollInitX + uvScrollInitRandX - random0 * uvScrollInitRandX * 2.0;
    float uvScrInitY  = uvScrollInitY + uvScrollInitRandY - random1 * uvScrollInitRandY * 2.0;
    float uvSclInitX  = uvScaleInitX  + uvScaleInitRandX  + random3 * uvScaleInitRandX;
    float uvSclInitY  = uvScaleInitY  + uvScaleInitRandY  + random4 * uvScaleInitRandY;

    // 非ストライプ
    float scrX =  -uvScrInitX - uvScrollAddX * time + indexX * uScale;
    float scrY =   uvScrInitY + uvScrollAddY * time - indexY * vScale;
    float sclX =   uvSclInitX + uvScaleAddX  * time;
    float sclY =   uvSclInitY + uvScaleAddY  * time;

    // 返り値のzw には、スクロール値を代入する
    ret.z = scrX;
    ret.w = scrY;

#ifdef _PARTICLE

    ret.x = ( inUv.x + 0.5 ) *  uScale + scrX - ( 1.0 - sclX ) * inUv.x;
    ret.y = ( inUv.y - 0.5 ) * -vScale - scrY + ( 1.0 - sclY ) * inUv.y;

    //ret.x = ( inUv.x * uScale + 0.5 * uScale )   + scrX - ( inUv.x - sclX * inUv.x );
    //ret.y = ( inUv.y * -vScale - 0.5 * -vScale)  - scrY + ( inUv.y - sclY * inUv.y ) ;

#endif
#ifdef _PRIMITIVE
    float texu = ( inUv.x * uScale - 0.5 );
    float texv = ( inUv.y * vScale - 0.5 );
    ret.x = texu * sclX + scrX + 0.5;
    ret.y = texv * sclY - scrY + 0.5;
#endif

    return ret;
}


vec4 CalculateTextureShiftAnimWithRotate( vec2 inUv, ResTexUvShiftAnim anim,
                               float time, int index, int randomMode, vec4 randomSeed )
{
    vec4 ret;

    #define uvScrollAddX        anim.pm0.x
    #define uvScrollAddY        anim.pm0.y
    #define uvScrollInitX       anim.pm0.z
    #define uvScrollInitY       anim.pm0.w
    #define uvScrollInitRandX   anim.pm1.x
    #define uvScrollInitRandY   anim.pm1.y
    #define uvScaleAddX         anim.pm1.z
    #define uvScaleAddY         anim.pm1.w
    #define uvScaleInitX        anim.pm2.x
    #define uvScaleInitY        anim.pm2.y
    #define uvScaleInitRandX    anim.pm2.z
    #define uvScaleInitRandY    anim.pm2.w
    #define uvRotateAdd         anim.pm3.x
    #define uvRotateInit        anim.pm3.y
    #define uvRotateInitRand    anim.pm3.z
    #define uvRotateInit        anim.pm3.y
    #define uvRotateInitRand    anim.pm3.z
    #define uvScaleBaseX        anim.pm4.x
    #define uvScaleBaseY        anim.pm4.y
    #define uvDivX              anim.pm4.z
    #define uvDivY              anim.pm4.w

    float random0 = randomSeed.x;
    float random1 = randomSeed.y;
    float random2 = randomSeed.z;
    float random3 = randomSeed.x;
    float random4 = randomSeed.y;

    if ( randomMode == 1 )
    {
        random0 = randomSeed.y;
        random1 = randomSeed.z;
        random2 = randomSeed.x;
        random3 = randomSeed.y;
        random4 = randomSeed.z;
    }
    else if ( randomMode == 2 )
    {
        random0 = randomSeed.z;
        random1 = randomSeed.x;
        random2 = randomSeed.y;
        random3 = randomSeed.x;
        random4 = randomSeed.y;
    }

    // 分割数
    int divX = int( uvDivX );
    int divY = int( uvDivY );

    // 分割後の表示位置
    int indexX = index % divX;
    int indexY = index / divX;

    // UVスケール
    float uScale = uvScaleBaseX * (1/uvDivX);
    float vScale = uvScaleBaseY * (1/uvDivY);

    // 初期値
    float uvScrInitX  = uvScrollInitX + uvScrollInitRandX - random0 * uvScrollInitRandX * 2.0;
    float uvScrInitY  = uvScrollInitY + uvScrollInitRandY - random1 * uvScrollInitRandY * 2.0;
    float uvRotInit   = uvRotateInit  + uvRotateInitRand  + random2 * uvRotateInitRand;
    float uvSclInitX  = uvScaleInitX  + uvScaleInitRandX  + random3 * uvScaleInitRandX;
    float uvSclInitY  = uvScaleInitY  + uvScaleInitRandY  + random4 * uvScaleInitRandY;

    // 時間経過考慮
#ifdef _USE_STRIPE

    // ストライプ使用時
    float scrX =  -uvScrInitX + uvScrollAddX * time + indexX * uScale;
    float scrY =  uvScrInitY + uvScrollAddY * time - indexY * vScale;
    float rot  =  uvRotInit  + uvRotateAdd  * time;
    float sclX =  uvSclInitX + uvScaleAddX  * time;
    float sclY =  uvSclInitY + uvScaleAddY  * time;

    // 返り値のzw には、スクロール値を代入する
    ret.z = scrX;
    ret.w = scrY;

    float inposx = inUv.x - 0.5;
    float inposy = inUv.y + 0.5;

    float sinZ = sin( -rot );
    float cosZ = cos( -rot );

    float texu = inposx * cosZ - inposy * sinZ;
    float texv = inposx * sinZ + inposy * cosZ;
    ret.x = ( texu + 0.5 ) *  uScale + scrX - ( 1.0 - sclX ) * texu;
    ret.y = ( texv - 0.5 ) * -vScale - scrY + ( 1.0 - sclY ) * texv;

#else

    // 非ストライプ
    float scrX =  -uvScrInitX - uvScrollAddX * time + indexX * uScale;
    float scrY =  uvScrInitY + uvScrollAddY * time - indexY * vScale;
    float rot  =  uvRotInit  + uvRotateAdd  * time;
    float sclX =  uvSclInitX + uvScaleAddX  * time;
    float sclY =  uvSclInitY + uvScaleAddY  * time;

    // 返り値のzw には、スクロール値を代入する
    ret.z = scrX;
    ret.w = scrY;

    float sinZ = sin( -rot );
    float cosZ = cos( -rot );

#ifdef _PARTICLE
    float texu = inUv.x * cosZ - inUv.y * sinZ;
    float texv = inUv.x * sinZ + inUv.y * cosZ;
    ret.x = ( texu + 0.5 ) *  uScale + scrX - ( 1.0 - sclX ) * texu;
    ret.y = ( texv - 0.5 ) * -vScale - scrY + ( 1.0 - sclY ) * texv;
#endif
#ifdef _PRIMITIVE
    float texu = ( inUv.x * uScale - 0.5 ) * cosZ - ( inUv.y * vScale - 0.5 ) * sinZ;
    float texv = ( inUv.x * uScale - 0.5 ) * sinZ + ( inUv.y * vScale - 0.5 ) * cosZ;
    ret.x = texu * sclX + scrX + 0.5;
    ret.y = texv * sclY - scrY + 0.5;
#endif

#endif

    return ret;
}

//------------------------------------------------------------------------------
// ライフフィットアニメーション処理
int CalculateTexPtnAnim_LifeFit( int table, int freq, float time, float life )
{
    int ptnIx = int( ( time * table ) / life );
    return ptnIx;
}

// ランダムアニメーション処理
int CalculateTexPtnAnim_Random( int table, float random )
{
    return int( table * random );
}

// ループアニメーション処理
int CalculateTexPtnAnim_Loop( int table, int freq, float time, float random, int bit )
{
    int ptnIx   = int( time / freq );
#if 1
    int f = GET_BIT_FLAG( bit );
    return ptnIx + f * int( table * random );
#else
    if ( CHECK_BIT_FLAG( bit ) )
    {
        ptnIx += int( table * random );
    }
    return ptnIx;
#endif
}

// クランプアニメーション処理
int CalculateTexPtnAnim_Clamp( int table, int freq, float time )
{
#if 0
    int ptnIx = int( time / freq );

    // クランプコマの修正。
    if ( table <= ptnIx )
    {
        ptnIx = table-1;
    }
    else
    {
        ptnIx = ptnIx % table;
    }
    return ptnIx;
#else
    int ptnIx = int( time / freq );
    // クランプコマの修正。
    int f = int( GET_FLAG_GREATER_EQ( ptnIx, table ) );
    int retA = ( table-1 );
    int retB = ( ptnIx % table );
    return f * retA + ( 1 - f ) * retB;
#endif
}

//------------------------------------------------------------------------------
// テクスチャパタンアニメーション（マクロ版）
//------------------------------------------------------------------------------

#if 0
// テクスチャ パタン テーブルから値を引く
#define GET_TEXTURE_PTN_TABLE_DEFINE( ID, TEX_PAT_ANIM )    \
int GetTexturePtnTable##ID( int ptnIx, int table )          \
{                                                           \
    int ret = 0;                                            \
    int idx = ptnIx % table;                                \
    int a = idx % 4;                                        \
    if ( a == 0 ) ret = TEX_PAT_ANIM.t[ idx/4 ].x;          \
    if ( a == 1 ) ret = TEX_PAT_ANIM.t[ idx/4 ].y;          \
    if ( a == 2 ) ret = TEX_PAT_ANIM.t[ idx/4 ].z;          \
    if ( a == 3 ) ret = TEX_PAT_ANIM.t[ idx/4 ].w;          \
    return ret;                                             \
}
#else
#define GET_TEXTURE_PTN_TABLE_DEFINE( ID, TEX_PAT_ANIM )                \
int GetTexturePtnTable##ID( int ptnIx, int table )                      \
{                                                                       \
    int ret = 0;                                                        \
    int idx = ptnIx % table;                                            \
    int a = idx % 4;                                                    \
    ivec4 temp = TEX_PAT_ANIM.t[ idx/4 ];                               \
    ivec4 v;                                                            \
    v.x = GET_FLAG_EQUAL( a, 0 );                                       \
    v.y = GET_FLAG_EQUAL( a, 1 );                                       \
    v.z = GET_FLAG_EQUAL( a, 2 );                                       \
    v.w = GET_FLAG_EQUAL( a, 3 );                                       \
    return v.x * temp.x + v.y * temp.y + v.z * temp.z + v.w * temp.w;   \
}
#endif
//------------------------------------------------------------------------------
// テクスチャパタンアニメーション：実体定義
//------------------------------------------------------------------------------

// テクスチャ0
GET_TEXTURE_PTN_TABLE_DEFINE( 0, texPatAnim0 )
// テクスチャ1
GET_TEXTURE_PTN_TABLE_DEFINE( 1, texPatAnim1 )
// テクスチャ2
GET_TEXTURE_PTN_TABLE_DEFINE( 2, texPatAnim2 )

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// テクスチャパターンアニメーション コマ値を計算（マクロ版）
//------------------------------------------------------------------------------
#define CALC_TEX_PTN_ANIM_DEFINE( ID, TEX_PAT_ANIM )                                                             \
int CalculateTexPtnAnim##ID( float time, float life, float random )                                              \
{                                                                                                                \
    int table   = int( TEX_PAT_ANIM.pm.x );                                                                      \
    int freq    = int( TEX_PAT_ANIM.pm.y );                                                                      \
    int randNum = int( TEX_PAT_ANIM.pm.z );                                                                      \
    int f0 = GET_BIT_FLAG( BIT_FLAG_TEX##ID##_PTN_LIFE_FIT );                                                    \
    int f1 = GET_BIT_FLAG( BIT_FLAG_TEX##ID##_PTN_LIFE_CLAMP );                                                  \
    int f2 = GET_BIT_FLAG( BIT_FLAG_TEX##ID##_PTN_LIFE_LOOP );                                                   \
    int f3 = GET_BIT_FLAG( BIT_FLAG_TEX##ID##_PTN_LIFE_RANDOM );                                                 \
    int idxLifeFit = CalculateTexPtnAnim_LifeFit( table, freq, time, life );                                     \
    int idxClamp   = CalculateTexPtnAnim_Clamp( table, freq, time );                                             \
    int idxLoop    = CalculateTexPtnAnim_Loop( table, freq, time, random, BIT_FLAG_TEX##ID##_PTN_LOOP_RANDOM );  \
    int idxRandom  = CalculateTexPtnAnim_Random( table, random );                                                \
    int idx = f0 * idxLifeFit + f1 * idxClamp + f2 * idxLoop + f3 * idxRandom;                                   \
    return GetTexturePtnTable##ID( idx, table );                                                                 \
}

//------------------------------------------------------------------------------
// テクスチャパターンアニメーション コマ値を計算：実体定義
//------------------------------------------------------------------------------

// テクスチャ0
CALC_TEX_PTN_ANIM_DEFINE( 0, texPatAnim0 )
// テクスチャ1
CALC_TEX_PTN_ANIM_DEFINE( 1, texPatAnim1 )
// テクスチャ2
CALC_TEX_PTN_ANIM_DEFINE( 2, texPatAnim2 )

//------------------------------------------------------------------------------
// カメラオフセット
//------------------------------------------------------------------------------
vec3 CalculateCameraOffset( vec3 inPos )
{
    #define offsetParam ubCenter.z

    if ( CHECK_BIT_FLAG( BIT_FLAG_OFFSET_TYPE_CAMERA ) )
    {
        return normalize( sysEyePosition.xyz - inPos ) * offsetParam;
    }

    return vec3(0);
}

//------------------------------------------------------------------------------
//  8キーアニメーション（マクロ展開／非マクロ展開）
//------------------------------------------------------------------------------
#if _MACRO_BRANCH_8KEY_ANIME

// ループ数を含めた現在の時間位置を[0,1]で取得する
float Calc8KeyAnimLocalTime( float time, float loopRate, float isLoopRandom, float life, float random )
{
#if _USE_NW_EFT
    float flag = sign( loopRate );    // 0なら0、0より大なら1
    float localTime = fract( time / loopRate + isLoopRandom * random );
    return flag * localTime + ( 1 - flag ) * ( time / life );
#else
    // time: フレーム数
    // loopRate: このフレーム数でループする
    float localTime;
    if ( loopRate > 0.0 )
    {
        // ループあり（フレーム数loopRateでループする）
        localTime = time + isLoopRandom * random * loopRate;
        return fract( localTime / loopRate );
    }
    else
    {
        // ループ無し（寿命のフレーム数までの[0,1]）
        return time / life;
    }
    return 0.0;
#endif
}

// 指定区間の線形補間

#if 0
vec3 Get8KeyIntermediateValue( float localTime, vec4 param0, vec4 param1 )
{
    return vec3(1,1,1);
    vec3 vsub = param1.xyz - param0.xyz;
    float tsub = (param1.w - param0.w);
    float tbase = localTime - param0.w;
    return param0.xyz + vsub / tsub * tbase;
}
#else
#define Get8KeyIntermediateValue( localTime, param0, param1 ) \
    ( param0.xyz + ( param1.xyz - param0.xyz ) / ( param1.w - param0.w ) * ( localTime - param0.w ) )
#endif


#if 1
// キー数に応じて処理を軽い方に逃がすバージョン（1,2,4,8キーで対応）

#define DEFINE_CALC_1KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate1KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    return PARAM.v[ 0 ].xyz;                                                                \
}

#define DEFINE_CALC_2KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate2KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( f1 )     * PARAM.v[ 1 ].xyz;                                                   \
}

#define DEFINE_CALC_3KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate3KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( f2 )     * PARAM.v[ 2 ].xyz;                                                   \
}

#define DEFINE_CALC_4KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate4KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    vec3 r3 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 2 ], PARAM.v[ 3 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    float f3 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 3 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( 1 - f3 ) * f2 * r3                                                             \
         + ( f3 )     * PARAM.v[ 3 ].xyz;                                                   \
}

#define DEFINE_CALC_5KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate5KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    vec3 r3 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 2 ], PARAM.v[ 3 ] ).xyz;           \
    vec3 r4 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 3 ], PARAM.v[ 4 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    float f3 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 3 ].w );                               \
    float f4 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 4 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( 1 - f3 ) * f2 * r3                                                             \
         + ( 1 - f4 ) * f3 * r4                                                             \
         + ( f4 )     * PARAM.v[ 4 ].xyz;                                                   \
}

#define DEFINE_CALC_6KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate6KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    vec3 r3 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 2 ], PARAM.v[ 3 ] ).xyz;           \
    vec3 r4 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 3 ], PARAM.v[ 4 ] ).xyz;           \
    vec3 r5 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 4 ], PARAM.v[ 5 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    float f3 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 3 ].w );                               \
    float f4 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 4 ].w );                               \
    float f5 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 5 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( 1 - f3 ) * f2 * r3                                                             \
         + ( 1 - f4 ) * f3 * r4                                                             \
         + ( 1 - f5 ) * f4 * r5                                                             \
         + ( f5 )     * PARAM.v[ 5 ].xyz;                                                   \
}

#define DEFINE_CALC_7KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate7KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    vec3 r3 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 2 ], PARAM.v[ 3 ] ).xyz;           \
    vec3 r4 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 3 ], PARAM.v[ 4 ] ).xyz;           \
    vec3 r5 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 4 ], PARAM.v[ 5 ] ).xyz;           \
    vec3 r6 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 5 ], PARAM.v[ 6 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    float f3 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 3 ].w );                               \
    float f4 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 4 ].w );                               \
    float f5 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 5 ].w );                               \
    float f6 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 6 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( 1 - f3 ) * f2 * r3                                                             \
         + ( 1 - f4 ) * f3 * r4                                                             \
         + ( 1 - f5 ) * f4 * r5                                                             \
         + ( 1 - f6 ) * f5 * r6                                                             \
         + ( f6 )     * PARAM.v[ 6 ].xyz;                                                   \
}

#define DEFINE_CALC_8KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate8KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    vec3 r1 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 0 ], PARAM.v[ 1 ] ).xyz;           \
    vec3 r2 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 1 ], PARAM.v[ 2 ] ).xyz;           \
    vec3 r3 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 2 ], PARAM.v[ 3 ] ).xyz;           \
    vec3 r4 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 3 ], PARAM.v[ 4 ] ).xyz;           \
    vec3 r5 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 4 ], PARAM.v[ 5 ] ).xyz;           \
    vec3 r6 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 5 ], PARAM.v[ 6 ] ).xyz;           \
    vec3 r7 = Get8KeyIntermediateValue( tLocal, PARAM.v[ 6 ], PARAM.v[ 7 ] ).xyz;           \
    float f0 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 0 ].w );                               \
    float f1 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 1 ].w );                               \
    float f2 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 2 ].w );                               \
    float f3 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 3 ].w );                               \
    float f4 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 4 ].w );                               \
    float f5 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 5 ].w );                               \
    float f6 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 6 ].w );                               \
    float f7 = GET_FLAG_GREATER_EQ( tLocal, PARAM.v[ 7 ].w );                               \
    return ( 1 - f0 ) * PARAM.v[ 0 ].xyz                                                    \
         + ( 1 - f1 ) * f0 * r1                                                             \
         + ( 1 - f2 ) * f1 * r2                                                             \
         + ( 1 - f3 ) * f2 * r3                                                             \
         + ( 1 - f4 ) * f3 * r4                                                             \
         + ( 1 - f5 ) * f4 * r5                                                             \
         + ( 1 - f6 ) * f5 * r6                                                             \
         + ( 1 - f7 ) * f6 * r7                                                             \
         + ( f7 )     * PARAM.v[ 7 ].xyz;                                                   \
}

#else
#define DEFINE_CALC_8KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate8KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    return PARAM.v[0].xyz;                                                                  \
}
#endif

// 8キーアニメーションの計算関数の実体定義。
DEFINE_CALC_8KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_8KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_8KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_8KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_8KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_8KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_7KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_7KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_7KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_7KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_7KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_7KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_6KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_6KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_6KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_6KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_6KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_6KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_5KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_5KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_5KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_5KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_5KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_5KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_4KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_4KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_4KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_4KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_4KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_4KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_3KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_3KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_3KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_3KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_3KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_3KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_2KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_2KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_2KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_2KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_2KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_2KEY_ANIM( Shader, shaderAnim )

DEFINE_CALC_1KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_1KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_1KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_1KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_1KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_1KEY_ANIM( Shader, shaderAnim )

#else

// ループ数を含めた現在の時間位置を[0,1]で取得する
float Calc8KeyAnimLocalTime( float time, float loopRate, float isLoopRandom, float life, float random )
{
    // time: フレーム数
    // loopRate: このフレーム数でループする
    float localTime;
    if ( loopRate > 0.0 )
    {
        // ループあり（フレーム数loopRateでループする）
        localTime = time + isLoopRandom * random * loopRate;
        return fract( localTime / loopRate );
    }
    else
    {
        // ループ無し（寿命のフレーム数までの[0,1]）
        return time / life;
    }
    return 0.0;
}

// 指定区間の線形補間
vec3 Get8KeyIntermediateValue( float localTime, float t0, float t1, vec3 v0, vec3 v1 )
{
    return v0 + ( v1 - v0 ) / ( t1 - t0 ) * ( localTime - t0 );
}

// キー数に応じて処理を軽い方に逃がすバージョン（1,2,4,8キーで対応）
#define DEFINE_CALC_8KEY_ANIM( NAME, PARAM )                                                \
vec3 Calculate8KeyAnim##NAME( int keyNum, float time, float loopRate, float isLoopRandom, float life, float random )  \
{                                                                                           \
    float tLocal = Calc8KeyAnimLocalTime( time, loopRate, isLoopRandom, life, random );     \
    float t0 = PARAM.v[ 0 ].w;                                                              \
    float t1 = PARAM.v[ 1 ].w;                                                              \
    float t2 = PARAM.v[ 2 ].w;                                                              \
    float t3 = PARAM.v[ 3 ].w;                                                              \
    float t4 = PARAM.v[ 4 ].w;                                                              \
    float t5 = PARAM.v[ 5 ].w;                                                              \
    float t6 = PARAM.v[ 6 ].w;                                                              \
    float t7 = PARAM.v[ 7 ].w;                                                              \
    vec3 v0 = PARAM.v[ 0 ].xyz;                                                             \
    vec3 v1 = PARAM.v[ 1 ].xyz;                                                             \
    vec3 v2 = PARAM.v[ 2 ].xyz;                                                             \
    vec3 v3 = PARAM.v[ 3 ].xyz;                                                             \
    vec3 v4 = PARAM.v[ 4 ].xyz;                                                             \
    vec3 v5 = PARAM.v[ 5 ].xyz;                                                             \
    vec3 v6 = PARAM.v[ 6 ].xyz;                                                             \
    vec3 v7 = PARAM.v[ 7 ].xyz;                                                             \
    if( keyNum > 4 )                                                                        \
    {                                                                                       \
        if ( tLocal < t0 ){ return v0; }                                                    \
                                                                                            \
        int lastKeyIndex = keyNum - 1;                                                      \
        float lastKeyTime = PARAM.v[ lastKeyIndex ].w;                                      \
        if ( lastKeyTime <= tLocal ){ return PARAM.v[ lastKeyIndex ].xyz; }                 \
                                                                                            \
        if ( tLocal < t1 ){ return Get8KeyIntermediateValue( tLocal, t0, t1, v0, v1 ); }    \
        if ( tLocal < t2 ){ return Get8KeyIntermediateValue( tLocal, t1, t2, v1, v2 ); }    \
        if ( tLocal < t3 ){ return Get8KeyIntermediateValue( tLocal, t2, t3, v2, v3 ); }    \
        if ( tLocal < t4 ){ return Get8KeyIntermediateValue( tLocal, t3, t4, v3, v4 ); }    \
        if ( tLocal < t5 ){ return Get8KeyIntermediateValue( tLocal, t4, t5, v4, v5 ); }    \
        if ( tLocal < t6 ){ return Get8KeyIntermediateValue( tLocal, t5, t6, v5, v6 ); }    \
        if ( tLocal < t7 ){ return Get8KeyIntermediateValue( tLocal, t6, t7, v6, v7 ); }    \
        return v7;                                                                          \
    }                                                                                       \
    else if( keyNum == 3 || keyNum == 4 )                                                   \
    {                                                                                       \
        if ( tLocal < t0 ){ return v0; }                                                    \
        if ( tLocal < t1 ){ return Get8KeyIntermediateValue( tLocal, t0, t1, v0, v1 ); }    \
        if ( tLocal < t2 ){ return Get8KeyIntermediateValue( tLocal, t1, t2, v1, v2 ); }    \
        if ( tLocal < t3 ){ return Get8KeyIntermediateValue( tLocal, t2, t3, v2, v3 ); }    \
        return v3;                                                                          \
    }                                                                                       \
    else if( keyNum == 2 )                                                                  \
    {                                                                                       \
        if( tLocal < t0 ){ return v0; }                                                     \
        else if( tLocal < t1 ){ return Get8KeyIntermediateValue( tLocal, t0, t1, v0, v1 ); }\
        return v1;                                                                          \
    }                                                                                       \
    else if( keyNum == 1 )                                                                  \
    {                                                                                       \
        return v0;                                                                          \
    }                                                                                       \
}

// 8キーアニメーションの計算関数の実体定義。
DEFINE_CALC_8KEY_ANIM( Color0, color0Anim )
DEFINE_CALC_8KEY_ANIM( Color1, color1Anim )
DEFINE_CALC_8KEY_ANIM( Alpha0, alpha0Anim )
DEFINE_CALC_8KEY_ANIM( Alpha1, alpha1Anim )
DEFINE_CALC_8KEY_ANIM( Scale, scaleAnim )
DEFINE_CALC_8KEY_ANIM( Shader, shaderAnim )

#endif

//------------------------------------------------------------------------------
// TODO: （ここから）不要になったら消す
//------------------------------------------------------------------------------
#define sysFlagCoordVary sysFragCoordVary
#define sysFlagParamVary sysFragParamVary
#define sysPtclFlagCoordCenter sysPtclFragCoordCenter
//------------------------------------------------------------------------------
// TODO: （ここまで）不要になったら消す
//------------------------------------------------------------------------------
