﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブ/ビジビリティアニメグループデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicVisibilityAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicVisibilityAnimationData() :
            base()
        {
            this.AnimationFolderPath = string.Empty;
            this.AnimationFilePath = string.Empty;
            this.AnimationFile = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// アニメーションフォルダパスです。
        /// </summary>
        [DataModelPropertyGuid("ba6b5d38-5225-4800-9fa1-ba76b6ffa311")]
        public string AnimationFolderPath { get; set; }

        /// <summary>
        /// アニメーションファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("824eb542-bf2a-4b06-9b24-41d489566027")]
        public string AnimationFilePath { get; set; }

        /// <summary>
        /// アニメーションファイルです。
        /// </summary>
        [DataModelPropertyGuid("83bdfc08-97ab-4222-a559-9d54599adbc6")]
        public int AnimationFile { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelBasicVisibilityAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationFolderPath = srcDataModel.AnimationFolderPath;
            this.AnimationFilePath = srcDataModel.AnimationFilePath;
            this.AnimationFile = srcDataModel.AnimationFile;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AnimationFolderPath", this.AnimationFolderPath);
            this.WriteElement(context, "AnimationFilePath", this.AnimationFilePath);
            this.WriteElement(context, "AnimationFile", this.AnimationFile);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AnimationFolderPath = this.ReadElement(context, "AnimationFolderPath", this.AnimationFolderPath);
            this.AnimationFilePath = this.ReadElement(context, "AnimationFilePath", this.AnimationFilePath);
            this.AnimationFile = this.ReadElement(context, "AnimationFile", this.AnimationFile);

            return success;
        }
    }
}
