﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/ランダムタブデータです。
    /// </summary>
    [Serializable]
    public class RandomFe1Data : FieldDataBase
    {
        /// <summary>
        /// ランダムグループデータを取得または設定します。
        /// </summary>
        private RandomFe1ParamData randomFe1ParamData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomFe1Data() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// ランダムグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("dbed1dce-d9c0-43da-b066-45de94fff472")]
        public RandomFe1ParamData RandomFe1ParamData
        {
            get { return this.GetDataModelFromField(ref this.randomFe1ParamData, false); }
            set { this.SetDataModelToField(ref this.randomFe1ParamData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomFe1Data;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomFe1ParamData = srcDataModel.RandomFe1ParamData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "RandomFe1ParamData", this.RandomFe1ParamData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.RandomFe1ParamData = this.ReadElement(context, "RandomFe1ParamData", this.RandomFe1ParamData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.RandomFe1Data(PrevVersion.RandomFe1Data src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.RandomFe1Data();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.RandomFe1Data;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.RandomFe1ParamData = srcDataModel.RandomFe1ParamData;

            return true;
        }
    }
}
