﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャファイルグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureFileData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureFileData() :
            base()
        {
            this.FilePath = string.Empty;
            this.PatternDivU = 1;
            this.PatternDivV = 1;
            this.WrapTypeU = 1;
            this.WrapTypeV = 1;
            this.RandomInvU = false;
            this.RandomInvV = false;
            this.RepeatCount = 0;
            this.FilterMode = 0;
            this.AvailableMipMapLevel = 15.99f;
            this.MipMapBias = 0.0f;
            this.MipMapLevelLimit = false;
            this.SphericalMap = false;
            this.UvChannel = 0;
            this.IsSquareRGB = false;

            this.PostConstruct();
        }

        /// <summary>
        /// テクスチャのファイルパスを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("592dc31f-ed3c-4f2b-b100-73e6fbc84159")]
        public string FilePath { get; set; }

        /// <summary>
        /// パターン分割Uの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("701302eb-69aa-4cc9-ad9a-7bb0e6ba98e7")]
        public int PatternDivU { get; set; }

        /// <summary>
        /// パターン分割Vの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a8ffa8a2-3e3f-4059-a787-a63e1e2925a1")]
        public int PatternDivV { get; set; }

        /// <summary>
        /// ラップUの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3aec6259-dee6-4a34-bf6a-51e5af7ac77f")]
        public int WrapTypeU { get; set; }

        /// <summary>
        /// ラップVの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("11f32d42-3add-4b70-a56c-b8bdb1dda0bd")]
        public int WrapTypeV { get; set; }

        /// <summary>
        /// ランダム反転U座標のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("54106bc9-6043-4768-9f9b-4e2b3df502cd")]
        public bool RandomInvU { get; set; }

        /// <summary>
        /// ランダム反転V座標のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f5234fc9-f48b-4b23-b501-20061d344d81")]
        public bool RandomInvV { get; set; }

        /// <summary>
        /// 繰り返し数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("496e1963-6dbc-42aa-b567-a7edbe4fe727")]
        public int RepeatCount { get; set; }

        /// <summary>
        /// フィルタモードを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6883aa33-6884-45f3-ab00-0b096afb0b19")]
        public int FilterMode { get; set; }

        /// <summary>
        /// 有効なミップレベルを取得または設定します。
        /// この値は使用しません。
        /// </summary>
        [DataModelPropertyGuid("6348c8d1-df8d-4f75-9f33-25c75193a9fb")]
        public float AvailableMipMapLevel { get; set; }

        /// <summary>
        /// ミップマップバイアスを取得または設定します。
        /// この値は使用しません。
        /// </summary>
        [DataModelPropertyGuid("e875d783-a6d3-4445-b8c6-a231b4555638")]
        public float MipMapBias { get; set; }

        /// <summary>
        /// ミップマップレベルを制限のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9e949eb5-af3e-40bf-8854-3ca091a58914")]
        public bool MipMapLevelLimit { get; set; }

        /// <summary>
        /// スフィアマップのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4a71894b-0f60-41b8-a46b-67b04ade9ac7")]
        public bool SphericalMap { get; set; }

        /// <summary>
        /// 適用するUVセットを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("310db07a-7857-4d95-a964-a7ff14fe50df")]
        public int UvChannel { get; set; }

        /// <summary>
        /// RGBを二乗して取得のOn/Offを取得または設定します。
        /// この機能はリニアの近似として利用します。
        /// </summary>
        [DataModelPropertyGuid("56196fed-b992-4c32-bbf6-3815dcf1c387")]
        public bool IsSquareRGB { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterTextureFileData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.FilePath = srcDataModel.FilePath;
            this.PatternDivU = srcDataModel.PatternDivU;
            this.PatternDivV = srcDataModel.PatternDivV;
            this.WrapTypeU = srcDataModel.WrapTypeU;
            this.WrapTypeV = srcDataModel.WrapTypeV;
            this.RandomInvU = srcDataModel.RandomInvU;
            this.RandomInvV = srcDataModel.RandomInvV;
            this.RepeatCount = srcDataModel.RepeatCount;
            this.FilterMode = srcDataModel.FilterMode;
            this.AvailableMipMapLevel = srcDataModel.AvailableMipMapLevel;
            this.MipMapBias = srcDataModel.MipMapBias;
            this.MipMapLevelLimit = srcDataModel.MipMapLevelLimit;
            this.SphericalMap = srcDataModel.SphericalMap;
            this.UvChannel = srcDataModel.UvChannel;
            this.IsSquareRGB = srcDataModel.IsSquareRGB;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "FilePath", this.FilePath);
            this.WriteElement(context, "PatternDivU", this.PatternDivU);
            this.WriteElement(context, "PatternDivV", this.PatternDivV);
            this.WriteElement(context, "WrapTypeU", this.WrapTypeU);
            this.WriteElement(context, "WrapTypeV", this.WrapTypeV);
            this.WriteElement(context, "RandomInvU", this.RandomInvU);
            this.WriteElement(context, "RandomInvV", this.RandomInvV);
            this.WriteElement(context, "RepeatCount", this.RepeatCount);
            this.WriteElement(context, "FilterMode", this.FilterMode);
            this.WriteElement(context, "AvailableMipMapLevel", this.AvailableMipMapLevel);
            this.WriteElement(context, "MipMapBias", this.MipMapBias);
            this.WriteElement(context, "MipMapLevelLimit", this.MipMapLevelLimit);
            this.WriteElement(context, "SphericalMap", this.SphericalMap);
            this.WriteElement(context, "UvChannel", this.UvChannel);
            this.WriteElement(context, "IsSquareRGB", this.IsSquareRGB);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.FilePath = this.ReadElement(context, "FilePath", this.FilePath);
            this.PatternDivU = this.ReadElement(context, "PatternDivU", this.PatternDivU);
            this.PatternDivV = this.ReadElement(context, "PatternDivV", this.PatternDivV);
            this.WrapTypeU = this.ReadElement(context, "WrapTypeU", this.WrapTypeU);
            this.WrapTypeV = this.ReadElement(context, "WrapTypeV", this.WrapTypeV);
            this.RandomInvU = this.ReadElement(context, "RandomInvU", this.RandomInvU);
            this.RandomInvV = this.ReadElement(context, "RandomInvV", this.RandomInvV);
            this.RepeatCount = this.ReadElement(context, "RepeatCount", this.RepeatCount);
            this.FilterMode = this.ReadElement(context, "FilterMode", this.FilterMode);
            this.AvailableMipMapLevel = this.ReadElement(context, "AvailableMipMapLevel", this.AvailableMipMapLevel);
            this.MipMapBias = this.ReadElement(context, "MipMapBias", this.MipMapBias);
            this.MipMapLevelLimit = this.ReadElement(context, "MipMapLevelLimit", this.MipMapLevelLimit);
            this.SphericalMap = this.ReadElement(context, "SphericalMap", this.SphericalMap);
            this.UvChannel = this.ReadElement(context, "UvChannel", this.UvChannel);
            this.IsSquareRGB = this.ReadElement(context, "IsSquareRGB", this.IsSquareRGB);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterTextureFileData(PrevVersion.EmitterTextureFileData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterTextureFileData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterTextureFileData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.FilePath = srcDataModel.FilePath;
            this.PatternDivU = srcDataModel.PatternDivU;
            this.PatternDivV = srcDataModel.PatternDivV;
            this.WrapTypeU = srcDataModel.WrapTypeU;
            this.WrapTypeV = srcDataModel.WrapTypeV;
            this.RandomInvU = srcDataModel.RandomInvU;
            this.RandomInvV = srcDataModel.RandomInvV;
            this.RepeatCount = srcDataModel.RepeatCount;
            this.FilterMode = srcDataModel.FilterMode;
            this.AvailableMipMapLevel = srcDataModel.AvailableMipMapLevel;
            this.MipMapBias = srcDataModel.MipMapBias;
            this.MipMapLevelLimit = srcDataModel.MipMapLevelLimit;
            this.SphericalMap = srcDataModel.SphericalMap;
            this.UvChannel = srcDataModel.UvChannel;
            this.IsSquareRGB = srcDataModel.IsSquareRGB;

            return true;
        }
    }
}
