﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/アルファ処理グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorAlphaProcessingData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorAlphaProcessingData() :
            base()
        {
            this.SoftParticleProcessType = 0;
            this.AlphaFadeStartAlphaOffset = 0;
            this.AlphaSamplingRadius = 0.5f;
            this.FresnelAlphaProcessType = 0;
            this.MinimumAlphaAngle = 0.0f;
            this.MaximumAlphaAngle = 1.0f;
            this.EnableNearAlpha = false;
            this.NearAlphaZeroDistance = 10.0f;
            this.NearAlphaOneDistance = 30.0f;
            this.EnableFarAlpha = false;
            this.FarAlphaOneDistance = 80.0f;
            this.FarAlphaZeroDistance = 100.0f;
            this.EnableDecal = false;
            this.DecalAlphaOneDistance = 1.0f;
            this.FeedStartDistance = 0.0f;
            this.VolumeValue = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// ソフトパーティクルの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8f928456-1a28-46c6-a5f2-9bccf3987fb5")]
        public int SoftParticleProcessType { get; set; }

        /// <summary>
        /// フェード開始α値オフセットを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d615208b-6018-4c43-b711-7291a51ab076")]
        public float AlphaFadeStartAlphaOffset { get; set; }

        /// <summary>
        /// サンプリング半径を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f0377134-a7a5-4011-a147-70d8615bc6ac")]
        public float AlphaSamplingRadius { get; set; }

        /// <summary>
        /// フレネルアルファの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("61714463-9aba-4bb0-bf87-abbc358f0b55")]
        public int FresnelAlphaProcessType { get; set; }

        /// <summary>
        /// アルファが最小になる角度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e6b78f19-334c-4be4-8c51-649848451d7c")]
        public float MinimumAlphaAngle { get; set; }

        /// <summary>
        /// アルファが最大になる角度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("819634d9-c4d2-4480-bcfb-88cd067dd793")]
        public float MaximumAlphaAngle { get; set; }

        /// <summary>
        /// 近距離アルファのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7096f9b8-bdfc-4fb8-80f7-011edfc4b7e6")]
        public bool EnableNearAlpha { get; set; }

        /// <summary>
        /// 近距離アルファのアルファが0になる距離です。
        /// </summary>
        [DataModelPropertyGuid("7df2584c-81cc-414c-b06b-5636923e2ea5")]
        public float NearAlphaZeroDistance { get; set; }

        /// <summary>
        /// 近距離アルファのアルファが1になる距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6ca3ad32-92a0-4a52-b97e-49df6c567366")]
        public float NearAlphaOneDistance { get; set; }

        /// <summary>
        /// 遠距離アルファのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("328a41f8-691b-49f2-85db-47d15a2b7f5c")]
        public bool EnableFarAlpha { get; set; }

        /// <summary>
        /// 遠距離アルファのアルファが1になる距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("87e915b9-0eea-4809-8759-aa48f7d96841")]
        public float FarAlphaOneDistance { get; set; }

        /// <summary>
        /// 遠距離アルファのアルファが0になる距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f98685c9-bf33-4d33-ba00-abd5251bbdd6")]
        public float FarAlphaZeroDistance { get; set; }

        /// <summary>
        /// デカールのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9aeea11d-d914-46d3-be2e-f0f2cee1ec50")]
        public bool EnableDecal { get; set; }

        /// <summary>
        /// デカールのアルファが1になる範囲を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("31158800-3fdb-466e-adbc-7226fdb3680d")]
        public float DecalAlphaOneDistance { get; set; }

        /// <summary>
        /// フェード開始距離を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("181cd012-f007-4a39-8fac-a5c250acfe68")]
        public float FeedStartDistance { get; set; }

        /// <summary>
        /// ボリューム値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("193bf19e-4d71-491e-baac-49765e023d26")]
        public float VolumeValue { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorAlphaProcessingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SoftParticleProcessType = srcDataModel.SoftParticleProcessType;
            this.AlphaFadeStartAlphaOffset = srcDataModel.AlphaFadeStartAlphaOffset;
            this.AlphaSamplingRadius = srcDataModel.AlphaSamplingRadius;
            this.FresnelAlphaProcessType = srcDataModel.FresnelAlphaProcessType;
            this.MinimumAlphaAngle = srcDataModel.MinimumAlphaAngle;
            this.MaximumAlphaAngle = srcDataModel.MaximumAlphaAngle;
            this.EnableNearAlpha = srcDataModel.EnableNearAlpha;
            this.NearAlphaZeroDistance = srcDataModel.NearAlphaZeroDistance;
            this.NearAlphaOneDistance = srcDataModel.NearAlphaOneDistance;
            this.EnableFarAlpha = srcDataModel.EnableFarAlpha;
            this.FarAlphaOneDistance = srcDataModel.FarAlphaOneDistance;
            this.FarAlphaZeroDistance = srcDataModel.FarAlphaZeroDistance;
            this.EnableDecal = srcDataModel.EnableDecal;
            this.DecalAlphaOneDistance = srcDataModel.DecalAlphaOneDistance;
            this.FeedStartDistance = srcDataModel.FeedStartDistance;
            this.VolumeValue = srcDataModel.VolumeValue;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "SoftParticleProcessType", this.SoftParticleProcessType);
            this.WriteElement(context, "AlphaFadeStartAlphaOffset", this.AlphaFadeStartAlphaOffset);
            this.WriteElement(context, "AlphaSamplingRadius", this.AlphaSamplingRadius);
            this.WriteElement(context, "FresnelAlphaProcessType", this.FresnelAlphaProcessType);
            this.WriteElement(context, "MinimumAlphaAngle", this.MinimumAlphaAngle);
            this.WriteElement(context, "MaximumAlphaAngle", this.MaximumAlphaAngle);
            this.WriteElement(context, "EnableNearAlpha", this.EnableNearAlpha);
            this.WriteElement(context, "NearAlphaZeroDistance", this.NearAlphaZeroDistance);
            this.WriteElement(context, "NearAlphaOneDistance", this.NearAlphaOneDistance);
            this.WriteElement(context, "EnableFarAlpha", this.EnableFarAlpha);
            this.WriteElement(context, "FarAlphaOneDistance", this.FarAlphaOneDistance);
            this.WriteElement(context, "FarAlphaZeroDistance", this.FarAlphaZeroDistance);
            this.WriteElement(context, "EnableDecal", this.EnableDecal);
            this.WriteElement(context, "DecalAlphaOneDistance", this.DecalAlphaOneDistance);
            this.WriteElement(context, "FeedStartDistance", this.FeedStartDistance);
            this.WriteElement(context, "VolumeValue", this.VolumeValue);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.SoftParticleProcessType = this.ReadElement(context, "SoftParticleProcessType", this.SoftParticleProcessType);
            this.AlphaFadeStartAlphaOffset = this.ReadElement(context, "AlphaFadeStartAlphaOffset", this.AlphaFadeStartAlphaOffset);
            this.AlphaSamplingRadius = this.ReadElement(context, "AlphaSamplingRadius", this.AlphaSamplingRadius);
            this.FresnelAlphaProcessType = this.ReadElement(context, "FresnelAlphaProcessType", this.FresnelAlphaProcessType);
            this.MinimumAlphaAngle = this.ReadElement(context, "MinimumAlphaAngle", this.MinimumAlphaAngle);
            this.MaximumAlphaAngle = this.ReadElement(context, "MaximumAlphaAngle", this.MaximumAlphaAngle);
            this.EnableNearAlpha = this.ReadElement(context, "EnableNearAlpha", this.EnableNearAlpha);
            this.NearAlphaZeroDistance = this.ReadElement(context, "NearAlphaZeroDistance", this.NearAlphaZeroDistance);
            this.NearAlphaOneDistance = this.ReadElement(context, "NearAlphaOneDistance", this.NearAlphaOneDistance);
            this.EnableFarAlpha = this.ReadElement(context, "EnableFarAlpha", this.EnableFarAlpha);
            this.FarAlphaOneDistance = this.ReadElement(context, "FarAlphaOneDistance", this.FarAlphaOneDistance);
            this.FarAlphaZeroDistance = this.ReadElement(context, "FarAlphaZeroDistance", this.FarAlphaZeroDistance);
            this.EnableDecal = this.ReadElement(context, "EnableDecal", this.EnableDecal);
            this.DecalAlphaOneDistance = this.ReadElement(context, "DecalAlphaOneDistance", this.DecalAlphaOneDistance);
            this.FeedStartDistance = this.ReadElement(context, "FeedStartDistance", this.FeedStartDistance);
            this.VolumeValue = this.ReadElement(context, "VolumeValue", this.VolumeValue);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorAlphaProcessingData(PrevVersion.EmitterColorAlphaProcessingData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorAlphaProcessingData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorAlphaProcessingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.SoftParticleProcessType = srcDataModel.SoftParticleProcessType;
            this.AlphaFadeStartAlphaOffset = srcDataModel.AlphaFadeStartAlphaOffset;
            this.AlphaSamplingRadius = srcDataModel.AlphaSamplingRadius;
            this.FresnelAlphaProcessType = srcDataModel.FresnelAlphaProcessType;
            this.MinimumAlphaAngle = srcDataModel.MinimumAlphaAngle;
            this.MaximumAlphaAngle = srcDataModel.MaximumAlphaAngle;
            this.EnableNearAlpha = srcDataModel.EnableNearAlpha;
            this.NearAlphaZeroDistance = srcDataModel.NearAlphaZeroDistance;
            this.NearAlphaOneDistance = srcDataModel.NearAlphaOneDistance;
            this.EnableFarAlpha = srcDataModel.EnableFarAlpha;
            this.FarAlphaOneDistance = srcDataModel.FarAlphaOneDistance;
            this.FarAlphaZeroDistance = srcDataModel.FarAlphaZeroDistance;
            this.EnableDecal = srcDataModel.EnableDecal;
            this.DecalAlphaOneDistance = srcDataModel.DecalAlphaOneDistance;
            this.FeedStartDistance = srcDataModel.FeedStartDistance;
            this.VolumeValue = srcDataModel.VolumeValue;

            return true;
        }
    }
}
