﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_7;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/ランダムタブ/ランダムグループデータです。
    /// </summary>
    [Serializable]
    public class RandomFe1ParamData : DataModelBase
    {
        /// <summary>
        /// ランダム幅を取得または設定します。
        /// </summary>
        private Vector3f randomRange = null;

        /// <summary>
        /// ランダム幅のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomFe1ParamData() :
            base()
        {
            this.RandomRange = new Vector3f(0.02f, 0.02f, 0.02f);
            this.BlankFrames = 1;
            this.EnableAnimation = 0;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// ランダム幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0c491828-90ab-4fb4-95f3-098115d96253")]
        public Vector3f RandomRange
        {
            get { return this.GetObjectFromField(ref this.randomRange, false); }
            set { this.SetISettableToField(ref this.randomRange, value); }
        }

        /// <summary>
        /// ランダム適用間隔(フレーム)を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("870c4b56-846a-41a8-a3b7-e35336377749")]
        public int BlankFrames { get; set; }

        /// <summary>
        /// ランダム幅のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("59e5d441-d056-482a-9723-1cf6ffa7a59b")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// ランダム幅のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("65a0c3cd-6e4d-444f-ac70-3b00a19a3b3b")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// ランダム幅のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4927aa32-f066-44d4-8923-761ffadd3674")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ランダム幅のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("2f529fe4-7e31-4700-ab9e-0221ba1f31c3")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// ランダム幅のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2840fb6a-94db-445f-b37a-609cb14c7128")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomFe1ParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.RandomRange = srcDataModel.RandomRange;
            this.BlankFrames = srcDataModel.BlankFrames;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "RandomRange", this.RandomRange);
            this.WriteElement(context, "BlankFrames", this.BlankFrames);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.RandomRange = this.ReadElement(context, "RandomRange", this.RandomRange);
            this.BlankFrames = this.ReadElement(context, "BlankFrames", this.BlankFrames);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.RandomFe1ParamData(PrevVersion.RandomFe1ParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.RandomFe1ParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.RandomFe1ParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.RandomRange = srcDataModel.RandomRange;
            this.BlankFrames = srcDataModel.BlankFrames;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
