﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノード/基本設定タブデータです。
    /// </summary>
    [Serializable]
    public class ModelBasicSettingData : DataModelBase
    {
        /// <summary>
        /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
        /// </summary>
        private ModelBasicAnimationData modelBasicAnimationData = null;

        /// <summary>
        /// モデルノード/基本設定タブ/モデルグループです。
        /// </summary>
        private ModelBasicModelData modelBasicModelData = null;

        /// <summary>
        /// モデルノード/基本設定タブ/再生設定グループデータです。
        /// </summary>
        private ModelBasicPlaybackData modelBasicPlaybackData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelBasicSettingData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// モデルノード/基本設定タブ/キャラクタアニメグループデータです。
        /// </summary>
        [DataModelPropertyGuid("e980cb10-6bb2-4edf-8221-012af46a414f")]
        public ModelBasicAnimationData ModelBasicAnimationData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicAnimationData, false); }
            set { this.SetDataModelToField(ref this.modelBasicAnimationData, value); }
        }

        /// <summary>
        /// モデルノード/基本設定タブ/モデルグループです。
        /// </summary>
        [DataModelPropertyGuid("4a07fe3e-5a76-4669-bf3e-c649a1cac19d")]
        public ModelBasicModelData ModelBasicModelData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicModelData, false); }
            set { this.SetDataModelToField(ref this.modelBasicModelData, value); }
        }

        /// <summary>
        /// モデルノード/基本設定タブ/再生設定グループデータです。
        /// </summary>
        [DataModelPropertyGuid("534bfbf2-68a3-45ad-bd34-1dc2e401514b")]
        public ModelBasicPlaybackData ModelBasicPlaybackData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicPlaybackData, false); }
            set { this.SetDataModelToField(ref this.modelBasicPlaybackData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelBasicAnimationData = srcDataModel.ModelBasicAnimationData;
            this.ModelBasicModelData = srcDataModel.ModelBasicModelData;
            this.ModelBasicPlaybackData = srcDataModel.ModelBasicPlaybackData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ModelBasicAnimationData", this.ModelBasicAnimationData);
            this.WriteElement(context, "ModelBasicModelData", this.ModelBasicModelData);
            this.WriteElement(context, "ModelBasicPlaybackData", this.ModelBasicPlaybackData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ModelBasicAnimationData = this.ReadElement(context, "ModelBasicAnimationData", this.ModelBasicAnimationData);
            this.ModelBasicModelData = this.ReadElement(context, "ModelBasicModelData", this.ModelBasicModelData);
            this.ModelBasicPlaybackData = this.ReadElement(context, "ModelBasicPlaybackData", this.ModelBasicPlaybackData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ModelBasicSettingData(PrevVersion.ModelBasicSettingData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ModelBasicSettingData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ModelBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ModelBasicAnimationData = srcDataModel.ModelBasicAnimationData;
            this.ModelBasicModelData = srcDataModel.ModelBasicModelData;
            this.ModelBasicPlaybackData = srcDataModel.ModelBasicPlaybackData;

            return true;
        }
    }
}
