﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/エミッタタブ/エミッタトランスフォームグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterTransformData : DataModelBase
    {
        /// <summary>
        /// スケールを取得または設定します。
        /// </summary>
        private Vector3f emitterScale = null;

        /// <summary>
        /// スケールのエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData emitterScaleAnimation = null;

        /// <summary>
        /// 回転を取得または設定します。
        /// </summary>
        private Vector3f emitterRotation = null;

        /// <summary>
        /// 回転のランダム幅を取得または設定します。
        /// </summary>
        private Vector3f emitterRotationRandom = null;

        /// <summary>
        /// 回転のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData emitterRotationAnimation = null;

        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        private Vector3f emitterPosition = null;

        /// <summary>
        /// 位置のランダム幅を取得または設定します。
        /// </summary>
        private Vector3f emitterPositionRandom = null;

        /// <summary>
        /// 位置のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData emitterPositionAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterTransformData() :
            base()
        {
            this.EmitterScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterScaleOption = 1;
            this.EmitterRotation = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EmitterRotationRandom = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EmitterPosition = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EmitterPositionRandom = new Vector3f(0.0f, 0.0f, 0.0f);
            this.EnableUpdateRandom = false;

            this.PostConstruct();
        }

        /// <summary>
        /// スケールを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fed24bcb-449a-49b8-9e75-5a7aca2da84a")]
        public Vector3f EmitterScale
        {
            get { return this.GetObjectFromField(ref this.emitterScale, false); }
            set { this.SetISettableToField(ref this.emitterScale, value); }
        }

        /// <summary>
        /// エミッタのスケールです.
        /// </summary>
        [DataModelPropertyGuid("f561e420-083e-4141-861b-8ce49547a79b")]
        public int EmitterScaleOption { get; set; }

        /// <summary>
        /// スケールのエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f0afc8b8-3865-4d1f-835c-4e794d4e2c0c")]
        public EmitterAnimationCommonData EmitterScaleAnimation
        {
            get { return this.GetDataModelFromField(ref this.emitterScaleAnimation, false); }
            set { this.SetDataModelToField(ref this.emitterScaleAnimation, value); }
        }

        /// <summary>
        /// 回転を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d86d9d9f-557b-46ba-8cf7-ad9310a729db")]
        public Vector3f EmitterRotation
        {
            get { return this.GetObjectFromField(ref this.emitterRotation, false); }
            set { this.SetISettableToField(ref this.emitterRotation, value); }
        }

        /// <summary>
        /// 回転のランダム幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5d025a7f-e72d-4d42-948e-0da466399311")]
        public Vector3f EmitterRotationRandom
        {
            get { return this.GetObjectFromField(ref this.emitterRotationRandom, false); }
            set { this.SetISettableToField(ref this.emitterRotationRandom, value); }
        }

        /// <summary>
        /// 回転のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5ff64858-4d5b-4ebd-b8a3-20241b68f056")]
        public EmitterAnimationCommonData EmitterRotationAnimation
        {
            get { return this.GetDataModelFromField(ref this.emitterRotationAnimation, false); }
            set { this.SetDataModelToField(ref this.emitterRotationAnimation, value); }
        }

        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5d2e5c5a-f53d-46ea-b054-8f5cb0ff385b")]
        public Vector3f EmitterPosition
        {
            get { return this.GetObjectFromField(ref this.emitterPosition, false); }
            set { this.SetISettableToField(ref this.emitterPosition, value); }
        }

        /// <summary>
        /// 位置のランダム幅を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4151f056-901d-4bd7-9706-0ae225f56bae")]
        public Vector3f EmitterPositionRandom
        {
            get { return this.GetObjectFromField(ref this.emitterPositionRandom, false); }
            set { this.SetISettableToField(ref this.emitterPositionRandom, value); }
        }

        /// <summary>
        /// 位置のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("27dc21b3-7952-4b15-8fc4-c7892a3bc889")]
        public EmitterAnimationCommonData EmitterPositionAnimation
        {
            get { return this.GetDataModelFromField(ref this.emitterPositionAnimation, false); }
            set { this.SetDataModelToField(ref this.emitterPositionAnimation, value); }
        }

        /// <summary>
        /// ランダム幅の更新のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ff7accd1-f169-44f7-abba-9ebc73cf5291")]
        public bool EnableUpdateRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmitterTransformData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterScale = srcDataModel.EmitterScale;
            this.EmitterScaleOption = srcDataModel.EmitterScaleOption;
            this.EmitterScaleAnimation = srcDataModel.EmitterScaleAnimation;
            this.EmitterRotation = srcDataModel.EmitterRotation;
            this.EmitterRotationRandom = srcDataModel.EmitterRotationRandom;
            this.EmitterRotationAnimation = srcDataModel.EmitterRotationAnimation;
            this.EmitterPosition = srcDataModel.EmitterPosition;
            this.EmitterPositionRandom = srcDataModel.EmitterPositionRandom;
            this.EmitterPositionAnimation = srcDataModel.EmitterPositionAnimation;
            this.EnableUpdateRandom = srcDataModel.EnableUpdateRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterScale", this.EmitterScale);
            this.WriteElement(context, "EmitterScaleOption", this.EmitterScaleOption);
            this.WriteElement(context, "EmitterScaleAnimation", this.EmitterScaleAnimation);
            this.WriteElement(context, "EmitterRotation", this.EmitterRotation);
            this.WriteElement(context, "EmitterRotationRandom", this.EmitterRotationRandom);
            this.WriteElement(context, "EmitterRotationAnimation", this.EmitterRotationAnimation);
            this.WriteElement(context, "EmitterPosition", this.EmitterPosition);
            this.WriteElement(context, "EmitterPositionRandom", this.EmitterPositionRandom);
            this.WriteElement(context, "EmitterPositionAnimation", this.EmitterPositionAnimation);
            this.WriteElement(context, "EnableUpdateRandom", this.EnableUpdateRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterScale = this.ReadElement(context, "EmitterScale", this.EmitterScale);
            this.EmitterScaleOption = this.ReadElement(context, "EmitterScaleOption", this.EmitterScaleOption);
            this.EmitterScaleAnimation = this.ReadElement(context, "EmitterScaleAnimation", this.EmitterScaleAnimation);
            this.EmitterRotation = this.ReadElement(context, "EmitterRotation", this.EmitterRotation);
            this.EmitterRotationRandom = this.ReadElement(context, "EmitterRotationRandom", this.EmitterRotationRandom);
            this.EmitterRotationAnimation = this.ReadElement(context, "EmitterRotationAnimation", this.EmitterRotationAnimation);
            this.EmitterPosition = this.ReadElement(context, "EmitterPosition", this.EmitterPosition);
            this.EmitterPositionRandom = this.ReadElement(context, "EmitterPositionRandom", this.EmitterPositionRandom);
            this.EmitterPositionAnimation = this.ReadElement(context, "EmitterPositionAnimation", this.EmitterPositionAnimation);
            this.EnableUpdateRandom = this.ReadElement(context, "EnableUpdateRandom", this.EnableUpdateRandom);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmitterTransformData(PrevVersion.EmitterEmitterTransformData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmitterTransformData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmitterTransformData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterScale = srcDataModel.EmitterScale;
            this.EmitterScaleOption = srcDataModel.EmitterScaleOption;
            this.EmitterScaleAnimation = srcDataModel.EmitterScaleAnimation;
            this.EmitterRotation = srcDataModel.EmitterRotation;
            this.EmitterRotationRandom = srcDataModel.EmitterRotationRandom;
            this.EmitterRotationAnimation = srcDataModel.EmitterRotationAnimation;
            this.EmitterPosition = srcDataModel.EmitterPosition;
            this.EmitterPositionRandom = srcDataModel.EmitterPositionRandom;
            this.EmitterPositionAnimation = srcDataModel.EmitterPositionAnimation;
            this.EnableUpdateRandom = srcDataModel.EnableUpdateRandom;

            return true;
        }
    }
}
