﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Reflection;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// パーティクルスケールタブデータです。
    /// </summary>
    [Serializable]
    public class PreviewParticleScaleData : DataModelBase
    {
        /// <summary>
        /// パーティクルの大きさ
        /// </summary>
        private Vector3f particleScale = null;

        /// <summary>
        /// 放出時のみ作用するパーティクルの大きさ
        /// </summary>
        private Vector3f emissionParticleScale = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewParticleScaleData() :
            base()
        {
            this.ParticleScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmissionParticleScale = new Vector3f(1.0f, 1.0f, 1.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// パーティクルの大きさ
        /// </summary>
        [DataModelPropertyGuid("bf1d9d03-5689-424f-9cfc-393e8cf570a7")]
        public Vector3f ParticleScale
        {
            get { return this.GetObjectFromField(ref this.particleScale, false); }
            set { this.SetISettableToField(ref this.particleScale, value); }
        }

        /// <summary>
        /// 放出時のみ作用するパーティクルの大きさ
        /// </summary>
        [DataModelPropertyGuid("ec0c0e28-2025-49e4-8b98-2bf0153c24eb")]
        public Vector3f EmissionParticleScale
        {
            get { return this.GetObjectFromField(ref this.emissionParticleScale, false); }
            set { this.SetISettableToField(ref this.emissionParticleScale, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewParticleScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleScale = srcDataModel.ParticleScale;
            this.EmissionParticleScale = srcDataModel.EmissionParticleScale;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ParticleScale", this.ParticleScale);
            this.WriteElement(context, "EmissionParticleScale", this.EmissionParticleScale);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ParticleScale = this.ReadElement(context, "ParticleScale", this.ParticleScale);
            this.EmissionParticleScale = this.ReadElement(context, "EmissionParticleScale", this.EmissionParticleScale);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewParticleScaleData(PrevVersion.PreviewParticleScaleData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewParticleScaleData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewParticleScaleData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ParticleScale = srcDataModel.ParticleScale;
            this.EmissionParticleScale = srcDataModel.EmissionParticleScale;

            return true;
        }
    }
}
