﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャサブタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureData : DataModelBase
    {
        /// <summary>
        /// テクスチャグループデータを取得または設定します。
        /// </summary>
        private EmitterTextureFileData emitterTextureFileData = null;

        /// <summary>
        /// テクスチャ座標アニメグループデータを取得または設定します。.
        /// </summary>
        private EmitterTextureUvAnimationData emitterTextureUvAnimationData = null;

        /// <summary>
        /// テクスチャパターンアニメグループデータを取得または設定します。
        /// </summary>
        private EmitterTexturePatternAnimationData emitterTexturePatternAnimationData = null;

        /// <summary>
        /// テクスチャオプショングループデータを取得または設定します。
        /// </summary>
        private EmitterTextureOptionData emitterTextureOptionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// テクスチャグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cd7c1012-4f48-444a-9874-8cdcde440145")]
        public EmitterTextureFileData EmitterTextureFileData
        {
            get { return this.GetDataModelFromField(ref this.emitterTextureFileData, false); }
            set { this.SetDataModelToField(ref this.emitterTextureFileData, value); }
        }

        /// <summary>
        /// テクスチャ座標アニメグループデータを取得または設定します。.
        /// </summary>
        [DataModelPropertyGuid("266ca54e-b779-42d3-abb5-c11b021360b7")]
        public EmitterTextureUvAnimationData EmitterTextureUvAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterTextureUvAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterTextureUvAnimationData, value); }
        }

        /// <summary>
        /// テクスチャパターンアニメグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a0250cc3-69e7-4f38-9bb0-70126df38bed")]
        public EmitterTexturePatternAnimationData EmitterTexturePatternAnimationData
        {
            get { return this.GetDataModelFromField(ref this.emitterTexturePatternAnimationData, false); }
            set { this.SetDataModelToField(ref this.emitterTexturePatternAnimationData, value); }
        }

        /// <summary>
        /// テクスチャオプショングループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3715a81d-6e57-443c-8b5f-ae0a46f9264a")]
        public EmitterTextureOptionData EmitterTextureOptionData
        {
            get { return this.GetDataModelFromField(ref this.emitterTextureOptionData, false); }
            set { this.SetDataModelToField(ref this.emitterTextureOptionData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterTextureData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterTextureFileData = srcDataModel.EmitterTextureFileData;
            this.EmitterTextureUvAnimationData = srcDataModel.EmitterTextureUvAnimationData;
            this.EmitterTexturePatternAnimationData = srcDataModel.EmitterTexturePatternAnimationData;
            this.EmitterTextureOptionData = srcDataModel.EmitterTextureOptionData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterTextureFileData", this.EmitterTextureFileData);
            this.WriteElement(context, "EmitterTextureUvAnimationData", this.EmitterTextureUvAnimationData);
            this.WriteElement(context, "EmitterTexturePatternAnimationData", this.EmitterTexturePatternAnimationData);
            this.WriteElement(context, "EmitterTextureOptionData", this.EmitterTextureOptionData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterTextureFileData = this.ReadElement(context, "EmitterTextureFileData", this.EmitterTextureFileData);
            this.EmitterTextureUvAnimationData = this.ReadElement(context, "EmitterTextureUvAnimationData", this.EmitterTextureUvAnimationData);
            this.EmitterTexturePatternAnimationData = this.ReadElement(context, "EmitterTexturePatternAnimationData", this.EmitterTexturePatternAnimationData);
            this.EmitterTextureOptionData = this.ReadElement(context, "EmitterTextureOptionData", this.EmitterTextureOptionData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterTextureData(PrevVersion.EmitterTextureData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterTextureData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterTextureData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterTextureFileData = srcDataModel.EmitterTextureFileData;
            this.EmitterTextureUvAnimationData = srcDataModel.EmitterTextureUvAnimationData;
            this.EmitterTexturePatternAnimationData = srcDataModel.EmitterTexturePatternAnimationData;
            this.EmitterTextureOptionData = srcDataModel.EmitterTextureOptionData;

            return true;
        }
    }
}
