﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/カラー・アルファ設定グループ/アニメーションデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorSettingsAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorSettingsAnimationData() :
            base()
        {
            this.LoopFrame = 100;

            this.PostConstruct();
        }

        /// <summary>
        /// ループのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("46f0ba15-16c4-4e86-b322-bc72c410d52e")]
        public bool EnableLoop { get; set; }

        /// <summary>
        /// ループフレームを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8d47b838-0ea9-4a84-be3c-be095e7907e3")]
        public int LoopFrame { get; set; }

        /// <summary>
        /// スタート位置ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1d0a25ca-873d-4a7c-b068-83d310b47296")]
        public bool EnableStartRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorSettingsAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableLoop = srcDataModel.EnableLoop;
            this.LoopFrame = srcDataModel.LoopFrame;
            this.EnableStartRandom = srcDataModel.EnableStartRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableLoop", this.EnableLoop);
            this.WriteElement(context, "LoopFrame", this.LoopFrame);
            this.WriteElement(context, "EnableStartRandom", this.EnableStartRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableLoop = this.ReadElement(context, "EnableLoop", this.EnableLoop);
            this.LoopFrame = this.ReadElement(context, "LoopFrame", this.LoopFrame);
            this.EnableStartRandom = this.ReadElement(context, "EnableStartRandom", this.EnableStartRandom);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorSettingsAnimationData(PrevVersion.EmitterColorSettingsAnimationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorSettingsAnimationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorSettingsAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableLoop = srcDataModel.EnableLoop;
            this.LoopFrame = srcDataModel.LoopFrame;
            this.EnableStartRandom = srcDataModel.EnableStartRandom;

            return true;
        }
    }
}
