﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicSettingData : DataModelBase
    {
        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        private EmitterBasicBasicData emitterBasicBasicData = null;

        /// <summary>
        /// 乱数設定グループデータを取得または設定します。
        /// </summary>
        private EmitterBasicRandomData emitterBasicRandomData = null;

        /// <summary>
        /// 描画設定グループデータを取得または設定します。
        /// </summary>
        private EmitterBasicRenderData emitterBasicRenderData = null;

        /// <summary>
        /// LODグループデータを取得または設定します。
        /// </summary>
        private EmitterBasicLodData emitterBasicLodData = null;

        /// <summary>
        /// 継承設定グループデータを取得または設定します。
        /// </summary>
        private EmitterBasicInheritanceData emitterBasicInheritanceData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicSettingData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 基本設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f573aeed-42ea-45cf-bc24-3484c20d8efb")]
        public EmitterBasicBasicData EmitterBasicBasicData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicBasicData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicBasicData, value); }
        }

        /// <summary>
        /// 乱数設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("26c8ac29-ff19-4721-a78e-046dca942666")]
        public EmitterBasicRandomData EmitterBasicRandomData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicRandomData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicRandomData, value); }
        }

        /// <summary>
        /// 描画設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("11220f0c-bb02-4f8c-abdd-fcc4cf9852c8")]
        public EmitterBasicRenderData EmitterBasicRenderData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicRenderData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicRenderData, value); }
        }

        /// <summary>
        /// LODグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0d4450e1-65ee-4ef1-9f12-9204b0dcdd64")]
        public EmitterBasicLodData EmitterBasicLodData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicLodData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicLodData, value); }
        }

        /// <summary>
        /// 継承設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3f7dee85-7f8d-49a6-9591-212a4c48cb8f")]
        public EmitterBasicInheritanceData EmitterBasicInheritanceData
        {
            get { return this.GetDataModelFromField(ref this.emitterBasicInheritanceData, false); }
            set { this.SetDataModelToField(ref this.emitterBasicInheritanceData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterBasicBasicData = srcDataModel.EmitterBasicBasicData;
            this.EmitterBasicRandomData = srcDataModel.EmitterBasicRandomData;
            this.EmitterBasicRenderData = srcDataModel.EmitterBasicRenderData;
            this.EmitterBasicLodData = srcDataModel.EmitterBasicLodData;
            this.EmitterBasicInheritanceData = srcDataModel.EmitterBasicInheritanceData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterBasicBasicData", this.EmitterBasicBasicData);
            this.WriteElement(context, "EmitterBasicRandomData", this.EmitterBasicRandomData);
            this.WriteElement(context, "EmitterBasicRenderData", this.EmitterBasicRenderData);
            this.WriteElement(context, "EmitterBasicLodData", this.EmitterBasicLodData);
            this.WriteElement(context, "EmitterBasicInheritanceData", this.EmitterBasicInheritanceData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterBasicBasicData = this.ReadElement(context, "EmitterBasicBasicData", this.EmitterBasicBasicData);
            this.EmitterBasicRandomData = this.ReadElement(context, "EmitterBasicRandomData", this.EmitterBasicRandomData);
            this.EmitterBasicRenderData = this.ReadElement(context, "EmitterBasicRenderData", this.EmitterBasicRenderData);
            this.EmitterBasicLodData = this.ReadElement(context, "EmitterBasicLodData", this.EmitterBasicLodData);
            this.EmitterBasicInheritanceData = this.ReadElement(context, "EmitterBasicInheritanceData", this.EmitterBasicInheritanceData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterBasicSettingData(PrevVersion.EmitterBasicSettingData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterBasicSettingData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterBasicSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterBasicBasicData = srcDataModel.EmitterBasicBasicData;
            this.EmitterBasicRandomData = srcDataModel.EmitterBasicRandomData;
            this.EmitterBasicRenderData = srcDataModel.EmitterBasicRenderData;
            this.EmitterBasicLodData = srcDataModel.EmitterBasicLodData;
            this.EmitterBasicInheritanceData = srcDataModel.EmitterBasicInheritanceData;

            return true;
        }
    }
}
