﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブ/基本設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicBasicData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicBasicData() :
            base()
        {
            this.ParticleFollowType = 0;
            this.ProcessType = 1;
            this.EnableEndProcess = true;
            this.EnableAlphaFade = false;
            this.EnableScaleFade = false;
            this.AlphaFadeTime = 10;

            this.PostConstruct();
        }

        /// <summary>
        /// パーティクル追従タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ad1366d9-3dba-4cb4-a8ed-8987929b4b5f")]
        public int ParticleFollowType { get; set; }

        /// <summary>
        /// プロセスタイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4e81e16e-9a7c-40a3-acae-ea1826075646")]
        public int ProcessType { get; set; }

        /// <summary>
        /// 終了処理を有効化するかどうか取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5376956e-e460-47dd-b9df-a6d805397fbb")]
        public bool EnableEndProcess { get; set; }

        /// <summary>
        /// 終了処理のαフェードのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b6d5c6b5-e628-4763-b68f-9130fbddcf37")]
        public bool EnableAlphaFade { get; set; }

        /// <summary>
        /// 終了処理のスケールフェードのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b888fc78-253d-4300-8793-4ec7505385f5")]
        public bool EnableScaleFade { get; set; }

        /// <summary>
        /// 終了処理のフェードアウト時間を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("bf9e6d74-7ef2-4bd6-91d0-9972a7abb46a")]
        public int AlphaFadeTime { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterBasicBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleFollowType = srcDataModel.ParticleFollowType;
            this.ProcessType = srcDataModel.ProcessType;
            this.EnableEndProcess = srcDataModel.EnableEndProcess;
            this.EnableAlphaFade = srcDataModel.EnableAlphaFade;
            this.EnableScaleFade = srcDataModel.EnableScaleFade;
            this.AlphaFadeTime = srcDataModel.AlphaFadeTime;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ParticleFollowType", this.ParticleFollowType);
            this.WriteElement(context, "ProcessType", this.ProcessType);
            this.WriteElement(context, "EnableEndProcess", this.EnableEndProcess);
            this.WriteElement(context, "EnableAlphaFade", this.EnableAlphaFade);
            this.WriteElement(context, "EnableScaleFade", this.EnableScaleFade);
            this.WriteElement(context, "AlphaFadeTime", this.AlphaFadeTime);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ParticleFollowType = this.ReadElement(context, "ParticleFollowType", this.ParticleFollowType);
            this.ProcessType = this.ReadElement(context, "ProcessType", this.ProcessType);
            this.EnableEndProcess = this.ReadElement(context, "EnableEndProcess", this.EnableEndProcess);
            this.EnableAlphaFade = this.ReadElement(context, "EnableAlphaFade", this.EnableAlphaFade);
            this.EnableScaleFade = this.ReadElement(context, "EnableScaleFade", this.EnableScaleFade);
            this.AlphaFadeTime = this.ReadElement(context, "AlphaFadeTime", this.AlphaFadeTime);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterBasicBasicData(PrevVersion.EmitterBasicBasicData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterBasicBasicData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterBasicBasicData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ParticleFollowType = srcDataModel.ParticleFollowType;
            this.ProcessType = srcDataModel.ProcessType;
            this.EnableEndProcess = srcDataModel.EnableEndProcess;
            this.EnableAlphaFade = srcDataModel.EnableAlphaFade;
            this.EnableScaleFade = srcDataModel.EnableScaleFade;
            this.AlphaFadeTime = srcDataModel.AlphaFadeTime;

            return true;
        }
    }
}
