﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ワークスペース保存のために、エミッタセットに紐付いたプレビューリストをシリアライズするためのデータです。
    /// </summary>
    [Serializable]
    public class EmitterSetReferenceData : DataModelBase
    {
        /// <summary>
        /// プレビューリストです。
        /// </summary>
        private List<PreviewInstanceData> previewList = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetReferenceData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタセット名です。
        /// </summary>
        [DataModelPropertyGuid("db44b1b9-28a6-43ff-b362-281126918dfe")]
        public string Name { get; set; }

        /// <summary>
        /// エミッタセットのファイルパスです。
        /// </summary>
        [DataModelPropertyGuid("8a0b204e-6ef9-4219-9b0e-cdef8cc0fe1b")]
        public string FilePath { get; set; }

        /// <summary>
        /// プレビューリストです。
        /// </summary>
        [DataModelPropertyGuid("d75d84e7-cf11-44e2-9f61-142b4a6ae3ab")]
        public List<PreviewInstanceData> PreviewList
        {
            get { return this.GetDataModelListFromField(ref this.previewList); }
            set { this.SetDataModelListToField(ref this.previewList, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterSetReferenceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.PreviewList = srcDataModel.PreviewList;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Name", this.Name);
            this.WriteElement(context, "FilePath", this.FilePath);
            this.WriteEnumerableElement(context, "PreviewList", this.PreviewList);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Name = this.ReadElement(context, "Name", this.Name);
            this.FilePath = this.ReadElement(context, "FilePath", this.FilePath);
            this.PreviewList = this.ReadListElement(context, "PreviewList", this.PreviewList);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterSetReferenceData(PrevVersion.EmitterSetReferenceData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterSetReferenceData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterSetReferenceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.FilePath = srcDataModel.FilePath;
            this.PreviewList = srcDataModel.PreviewList.Select(dm => (CurrVersion.PreviewInstanceData)dm).ToList();

            return true;
        }
    }
}
