﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルノードです。
    /// </summary>
    [Serializable]
    public class ModelData : DisplayableDataBase
    {
        /// <summary>
        /// 基本設定データです。
        /// </summary>
        private ModelBasicSettingData modelBasicSettingData = null;

        /// <summary>
        /// ボーン名です。
        /// </summary>
        private List<string> boneNames = null;

        /// <summary>
        /// ユーザーページデータです.
        /// </summary>
        private List<UserPageData> userPages = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelData() :
            base()
        {
            this.Name = string.Empty;
            this.IsRuntime = false;
            this.ModelBinaryId = -1;

            this.PostConstruct();
        }

        /// <summary>
        /// 基本設定データです。
        /// </summary>
        [DataModelPropertyGuid("0523dc0c-424b-403e-898f-79bf9c3a439b")]
        public ModelBasicSettingData ModelBasicSettingData
        {
            get { return this.GetDataModelFromField(ref this.modelBasicSettingData, false); }
            set { this.SetDataModelToField(ref this.modelBasicSettingData, value); }
        }

        /// <summary>
        /// モデル名です。
        /// </summary>
        [DataModelPropertyGuid("834ed8d5-8992-47c6-a11c-3e09984970f5")]
        public string Name { get; set; }

        /// <summary>
        /// ボーン名です。

        /// </summary>
        [DataModelPropertyGuid("1f7dd097-b96c-4aab-ab62-9033baa75583")]
        public List<string> BoneNames
        {
            get { return this.GetValueListFromField(ref this.boneNames); }
            set { this.SetValueListToField(ref this.boneNames, value); }
        }

        /// <summary>
        /// ランタイムで独立して管理しているモデルのデータモデルかどうかのフラグです.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("19e2f09d-4b25-4fae-a534-d45724af50ca")]
        public bool IsRuntime { get; set; }

        /// <summary>
        /// モデルバイナリのIDです.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("85e10561-e113-43ea-a339-ba52ac46374a")]
        public int ModelBinaryId { get; set; }

        /// <summary>
        /// ユーザーページデータです.
        /// </summary>
        [DataModelPropertyGuid("eac5f18c-8425-4d5d-84b4-fce07ba6da67")]
        public List<UserPageData> UserPages
        {
            get { return this.GetDataModelListFromField(ref this.userPages); }
            set { this.SetDataModelListToField(ref this.userPages, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ModelBasicSettingData = srcDataModel.ModelBasicSettingData;
            this.Name = srcDataModel.Name;
            this.BoneNames = srcDataModel.BoneNames;
            this.IsRuntime = srcDataModel.IsRuntime;
            this.ModelBinaryId = srcDataModel.ModelBinaryId;
            this.UserPages = srcDataModel.UserPages;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ModelBasicSettingData", this.ModelBasicSettingData);
            this.WriteElement(context, "Name", this.Name);
            this.WriteEnumerableElement(context, "BoneNames", this.BoneNames);
            this.WriteEnumerableElement(context, "UserPages", this.UserPages);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ModelBasicSettingData = this.ReadElement(context, "ModelBasicSettingData", this.ModelBasicSettingData);
            this.Name = this.ReadElement(context, "Name", this.Name);
            this.BoneNames = this.ReadListElement(context, "BoneNames", this.BoneNames);
            this.UserPages = this.ReadListElement(context, "UserPages", this.UserPages);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ModelData(PrevVersion.ModelData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ModelData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ModelData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ModelBasicSettingData = srcDataModel.ModelBasicSettingData;
            this.Name = srcDataModel.Name;
            this.BoneNames = srcDataModel.BoneNames;
            this.IsRuntime = srcDataModel.IsRuntime;
            this.ModelBinaryId = srcDataModel.ModelBinaryId;
            this.UserPages = srcDataModel.UserPages.Select(dm => (UserPageData)dm).ToList();

            return true;
        }
    }
}
